/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.db4j;

import com.github.paganini2008.devtools.db4j.ResultSetExtractor;
import com.github.paganini2008.devtools.db4j.TypeHandlerRegistry;
import com.github.paganini2008.devtools.db4j.mapper.RowMapper;
import com.github.paganini2008.devtools.jdbc.Cursor;
import com.github.paganini2008.devtools.jdbc.DetachedSqlException;
import com.github.paganini2008.devtools.jdbc.JdbcUtils;
import com.sun.rowset.CachedRowSetImpl;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class CachedCursorResultSetExtractor<T>
implements ResultSetExtractor<Cursor<T>> {
    private final RowMapper<T> rowMapper;
    private final TypeHandlerRegistry typeHandlerRegistry;

    CachedCursorResultSetExtractor(RowMapper<T> rowMapper, TypeHandlerRegistry typeHandlerRegistry) {
        if (rowMapper == null) {
            throw new IllegalArgumentException("RowMapper must not be null.");
        }
        this.rowMapper = rowMapper;
        this.typeHandlerRegistry = typeHandlerRegistry;
    }

    @Override
    public Cursor<T> extractData(ResultSet rs) throws SQLException {
        final CachedRowSetImpl delegate = new CachedRowSetImpl();
        delegate.populate(rs);
        this.configure(delegate);
        return new Cursor<T>(){
            private final AtomicInteger index = new AtomicInteger(0);
            private final AtomicBoolean opened = new AtomicBoolean(true);

            public boolean hasNext() {
                try {
                    this.opened.set(delegate.next());
                    boolean bl = this.opened.get();
                    return bl;
                }
                catch (SQLException e) {
                    this.opened.set(false);
                    throw new DetachedSqlException(e.getMessage(), (Throwable)e);
                }
                finally {
                    if (!this.isOpened()) {
                        this.close();
                    }
                }
            }

            public T next() {
                try {
                    Object t = CachedCursorResultSetExtractor.this.rowMapper.mapRow(this.index.incrementAndGet(), delegate, CachedCursorResultSetExtractor.this.typeHandlerRegistry);
                    return t;
                }
                catch (SQLException e) {
                    this.opened.set(false);
                    throw new DetachedSqlException(e.getMessage(), (Throwable)e);
                }
                finally {
                    if (!this.isOpened()) {
                        this.close();
                    }
                }
            }

            public int getRownum() {
                try {
                    return delegate.getRow();
                }
                catch (SQLException e) {
                    throw new DetachedSqlException(e.getMessage(), (Throwable)e);
                }
            }

            public void mark(int rownum) {
                try {
                    delegate.absolute(rownum);
                }
                catch (SQLException e) {
                    throw new DetachedSqlException(e.getMessage(), (Throwable)e);
                }
            }

            public boolean isOpened() {
                return this.opened.get();
            }

            public void close() {
                JdbcUtils.closeQuietly((ResultSet)delegate);
            }
        };
    }

    protected void configure(ResultSet delegate) {
    }
}

