/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.db4j;

import com.github.paganini2008.devtools.collection.MapUtils;
import com.github.paganini2008.devtools.db4j.GeneratedKey;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class GeneratedKeyImpl
implements GeneratedKey {
    private final Map<String, Object> keys = new LinkedHashMap<String, Object>();

    GeneratedKeyImpl(String ... columnNames) {
        if (columnNames != null) {
            for (String columnName : columnNames) {
                this.keys.put(columnName, null);
            }
        }
    }

    @Override
    public Number getKey() {
        Map.Entry<String, Object> entry;
        Iterator<Map.Entry<String, Object>> it = this.keys.entrySet().iterator();
        if (it.hasNext() && (entry = it.next()).getValue() instanceof Number) {
            return (Number)entry.getValue();
        }
        return null;
    }

    @Override
    public Map<String, Object> getKeys() {
        return Collections.unmodifiableMap(this.keys);
    }

    @Override
    public Object getKey(String keyName) {
        return this.keys.get(keyName);
    }

    @Override
    public String[] getKeyNames() {
        return this.keys.keySet().toArray(new String[this.keys.size()]);
    }

    @Override
    public void setKeys(Map<String, Object> map) {
        if (MapUtils.isNotEmpty(map)) {
            if (this.keys.isEmpty()) {
                this.keys.putAll(map);
            } else {
                Object[] values = map.values().toArray();
                if (values.length == this.keys.size()) {
                    int i = 0;
                    for (Map.Entry<String, Object> entry : this.keys.entrySet()) {
                        entry.setValue(values[i++]);
                    }
                }
            }
        }
    }
}

