/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.db4j;

import com.github.paganini2008.devtools.PlaceholderTokenParser;
import com.github.paganini2008.devtools.collection.LruMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class ParsedSql
implements Serializable {
    private static final long serialVersionUID = -7823481840053509465L;
    private static final LruMap<String, ParsedSql> parsedSqlCache = new LruMap(1024);
    private static final String DEFAULT_PLACEHOLDER_PREFIX = "{";
    private static final String DEFAULT_PLACEHOLDER_SUFFEX = "}";
    final StringBuilder rawSql = new StringBuilder();
    final List<String> parameterNames = new ArrayList<String>();
    final List<String> defaultValues = new ArrayList<String>();

    ParsedSql() {
    }

    public String[] getParameterNames() {
        return this.parameterNames.toArray(new String[0]);
    }

    public String[] getDefaultValues() {
        return this.defaultValues.toArray(new String[0]);
    }

    public StringBuilder getRawSql() {
        return this.rawSql;
    }

    public String toString() {
        return this.rawSql.toString();
    }

    public static ParsedSql parse(String sql) {
        return (ParsedSql)parsedSqlCache.getOrDefault((Object)sql, (Object)ParsedSql.doParse(sql));
    }

    private static ParsedSql doParse(String sql) {
        ParsedSql parsedSql = new ParsedSql();
        PlaceholderTokenParser placeholderTokenizer = new PlaceholderTokenParser(DEFAULT_PLACEHOLDER_PREFIX, DEFAULT_PLACEHOLDER_SUFFEX);
        parsedSql.rawSql.append(placeholderTokenizer.parse(sql, variable -> {
            String parameterName = variable;
            String defaultValue = null;
            int index = variable.indexOf(58);
            if (index > 0) {
                parameterName = variable.substring(0, index);
                defaultValue = variable.substring(index + 1);
            }
            parsedSql.parameterNames.add(parameterName);
            parsedSql.defaultValues.add(defaultValue);
            return "?";
        }));
        return parsedSql;
    }
}

