/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.db4j;

import com.github.paganini2008.devtools.collection.Tuple;
import com.github.paganini2008.devtools.db4j.ArraySqlParameter;
import com.github.paganini2008.devtools.db4j.GeneratedKey;
import com.github.paganini2008.devtools.db4j.JdbcType;
import com.github.paganini2008.devtools.db4j.ParsedSql;
import com.github.paganini2008.devtools.db4j.ResultSetExtractor;
import com.github.paganini2008.devtools.db4j.SqlParameter;
import com.github.paganini2008.devtools.db4j.SqlParameters;
import com.github.paganini2008.devtools.db4j.SqlRunner;
import com.github.paganini2008.devtools.db4j.SqlType;
import com.github.paganini2008.devtools.db4j.mapper.ColumnIndexRowMapper;
import com.github.paganini2008.devtools.db4j.mapper.RowMapper;
import com.github.paganini2008.devtools.db4j.mapper.TupleRowMapper;
import com.github.paganini2008.devtools.jdbc.ConnectionFactory;
import com.github.paganini2008.devtools.jdbc.Cursor;
import com.github.paganini2008.devtools.jdbc.DefaultPageableSql;
import com.github.paganini2008.devtools.jdbc.JdbcUtils;
import com.github.paganini2008.devtools.jdbc.PageableException;
import com.github.paganini2008.devtools.jdbc.PageableQuery;
import com.github.paganini2008.devtools.jdbc.PageableSlice;
import com.github.paganini2008.devtools.jdbc.PageableSql;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ParsedSqlRunner {
    private final SqlRunner sqlRunner = new SqlRunner();

    public <T> T query(Connection connection, String sql, Object[] args, ResultSetExtractor<T> extractor) throws SQLException {
        return this.query(connection, sql, new ArraySqlParameter(args), extractor);
    }

    public <T> T query(Connection connection, String sql, SqlParameter sqlParameter, ResultSetExtractor<T> extractor) throws SQLException {
        ParsedSql parsedSql = this.getParsedSql(sql);
        String rawSql = parsedSql.toString();
        Object[] parameters = sqlParameter != null ? this.getArguments(parsedSql, sqlParameter) : null;
        JdbcType[] jdbcTypes = sqlParameter != null ? this.getJdbcTypes(parsedSql, sqlParameter) : null;
        return this.sqlRunner.query(connection, rawSql, parameters, jdbcTypes, extractor);
    }

    public List<Tuple> queryForList(Connection connection, String sql, Object[] args) throws SQLException {
        return this.queryForList(connection, sql, new ArraySqlParameter(args));
    }

    public List<Tuple> queryForList(Connection connection, String sql, SqlParameter sqlParameter) throws SQLException {
        ParsedSql parsedSql = this.getParsedSql(sql);
        String rawSql = parsedSql.toString();
        Object[] parameters = sqlParameter != null ? this.getArguments(parsedSql, sqlParameter) : null;
        JdbcType[] jdbcTypes = sqlParameter != null ? this.getJdbcTypes(parsedSql, sqlParameter) : null;
        return this.sqlRunner.queryForList(connection, rawSql, parameters, jdbcTypes);
    }

    public Cursor<Tuple> queryForCursor(Connection connection, String sql, Object[] args) throws SQLException {
        return this.queryForCursor(connection, sql, new ArraySqlParameter(args));
    }

    public Cursor<Tuple> queryForCursor(Connection connection, String sql, SqlParameter sqlParameter) throws SQLException {
        ParsedSql parsedSql = this.getParsedSql(sql);
        String rawSql = parsedSql.toString();
        Object[] parameters = sqlParameter != null ? this.getArguments(parsedSql, sqlParameter) : null;
        JdbcType[] jdbcTypes = sqlParameter != null ? this.getJdbcTypes(parsedSql, sqlParameter) : null;
        return this.sqlRunner.queryForCursor(connection, rawSql, parameters, jdbcTypes);
    }

    public Cursor<Tuple> queryForCursor(Connection connection, String sql) throws SQLException {
        ParsedSql parsedSql = this.getParsedSql(sql);
        String rawSql = parsedSql.toString();
        return this.sqlRunner.queryForCursor(connection, rawSql);
    }

    public <T> List<T> queryForList(Connection connection, String sql, SqlParameter sqlParameter, RowMapper<T> rowMapper) throws SQLException {
        ParsedSql parsedSql = this.getParsedSql(sql);
        String rawSql = parsedSql.toString();
        Object[] parameters = sqlParameter != null ? this.getArguments(parsedSql, sqlParameter) : null;
        JdbcType[] jdbcTypes = sqlParameter != null ? this.getJdbcTypes(parsedSql, sqlParameter) : null;
        return this.sqlRunner.queryForList(connection, rawSql, parameters, jdbcTypes, rowMapper);
    }

    public <T> Cursor<T> queryForCursor(Connection connection, String sql, SqlParameter sqlParameter, RowMapper<T> rowMapper) throws SQLException {
        ParsedSql parsedSql = this.getParsedSql(sql);
        String rawSql = parsedSql.toString();
        Object[] parameters = sqlParameter != null ? this.getArguments(parsedSql, sqlParameter) : null;
        JdbcType[] jdbcTypes = sqlParameter != null ? this.getJdbcTypes(parsedSql, sqlParameter) : null;
        return this.sqlRunner.queryForCursor(connection, rawSql, parameters, jdbcTypes, rowMapper);
    }

    public <T> Cursor<T> queryForCachedCursor(Connection connection, String sql, Object[] args, RowMapper<T> rowMapper) throws SQLException {
        return this.queryForCachedCursor(connection, sql, new ArraySqlParameter(args), rowMapper);
    }

    public <T> Cursor<T> queryForCachedCursor(Connection connection, String sql, SqlParameter sqlParameter, RowMapper<T> rowMapper) throws SQLException {
        ParsedSql parsedSql = this.getParsedSql(sql);
        String rawSql = parsedSql.toString();
        Object[] parameters = sqlParameter != null ? this.getArguments(parsedSql, sqlParameter) : null;
        JdbcType[] jdbcTypes = sqlParameter != null ? this.getJdbcTypes(parsedSql, sqlParameter) : null;
        return this.sqlRunner.queryForCachedCursor(connection, rawSql, parameters, jdbcTypes, rowMapper);
    }

    public Cursor<Tuple> queryForCachedCursor(Connection connection, String sql, Object[] args) throws SQLException {
        return this.queryForCachedCursor(connection, sql, new ArraySqlParameter(args));
    }

    public Cursor<Tuple> queryForCachedCursor(Connection connection, String sql, SqlParameter sqlParameter) throws SQLException {
        ParsedSql parsedSql = this.getParsedSql(sql);
        String rawSql = parsedSql.toString();
        Object[] parameters = sqlParameter != null ? this.getArguments(parsedSql, sqlParameter) : null;
        JdbcType[] jdbcTypes = sqlParameter != null ? this.getJdbcTypes(parsedSql, sqlParameter) : null;
        return this.sqlRunner.queryForCachedCursor(connection, rawSql, parameters, jdbcTypes);
    }

    public Cursor<Tuple> queryForCachedCursor(Connection connection, String sql) throws SQLException {
        ParsedSql parsedSql = this.getParsedSql(sql);
        String rawSql = parsedSql.toString();
        return this.sqlRunner.queryForCachedCursor(connection, rawSql);
    }

    public <T> PageableQuery<T> queryForPage(ConnectionFactory connectionFactory, String sql, SqlParameter sqlParameter, RowMapper<T> rowMapper) {
        return new PageableQueryImpl(connectionFactory, (PageableSql)new DefaultPageableSql(sql), sqlParameter, rowMapper, this);
    }

    public <T> PageableQuery<T> queryForPage(ConnectionFactory connectionFactory, PageableSql pageableSql, SqlParameter sqlParameter, RowMapper<T> rowMapper) {
        return new PageableQueryImpl(connectionFactory, pageableSql, sqlParameter, rowMapper, this);
    }

    public PageableQuery<Tuple> queryForPage(ConnectionFactory connectionFactory, String sql, SqlParameter sqlParameter) {
        return this.queryForPage(connectionFactory, (PageableSql)new DefaultPageableSql(sql), sqlParameter);
    }

    public PageableQuery<Tuple> queryForPage(ConnectionFactory connectionFactory, PageableSql pageableSql, SqlParameter sqlParameter) {
        return this.queryForPage(connectionFactory, pageableSql, sqlParameter, new TupleRowMapper());
    }

    public <T> T queryForObject(Connection connection, String sql, SqlParameter sqlParameter, Class<T> requiredType) throws SQLException {
        return this.queryForObject(connection, sql, sqlParameter, new ColumnIndexRowMapper<T>(requiredType));
    }

    public <T> T queryForObject(Connection connection, String sql, SqlParameter sqlParameter, RowMapper<T> rowMapper) throws SQLException {
        ParsedSql parsedSql = this.getParsedSql(sql);
        String rawSql = parsedSql.toString();
        Object[] parameters = sqlParameter != null ? this.getArguments(parsedSql, sqlParameter) : null;
        JdbcType[] jdbcTypes = sqlParameter != null ? this.getJdbcTypes(parsedSql, sqlParameter) : null;
        return this.sqlRunner.queryForObject(connection, rawSql, parameters, jdbcTypes, rowMapper);
    }

    public int[] batchUpdate(Connection connection, String sql, SqlParameters sqlParameters) throws SQLException {
        ParsedSql parsedSql = this.getParsedSql(sql);
        String rawSql = parsedSql.toString();
        List<Object[]> parameterList = sqlParameters != null ? this.getArgumentsList(parsedSql, sqlParameters) : null;
        JdbcType[] jdbcTypes = sqlParameters != null ? this.getJdbcTypes(parsedSql, sqlParameters) : null;
        return this.sqlRunner.batchUpdate(connection, rawSql, parameterList, jdbcTypes);
    }

    public int update(Connection connection, String sql, SqlParameter sqlParameter) throws SQLException {
        ParsedSql parsedSql = this.getParsedSql(sql);
        String rawSql = parsedSql.toString();
        Object[] parameters = sqlParameter != null ? this.getArguments(parsedSql, sqlParameter) : null;
        JdbcType[] jdbcTypes = sqlParameter != null ? this.getJdbcTypes(parsedSql, sqlParameter) : null;
        return this.sqlRunner.update(connection, rawSql, parameters, jdbcTypes);
    }

    public int update(Connection connection, String sql, SqlParameter sqlParameter, GeneratedKey generatedKey) throws SQLException {
        ParsedSql parsedSql = this.getParsedSql(sql);
        String rawSql = parsedSql.toString();
        Object[] parameters = sqlParameter != null ? this.getArguments(parsedSql, sqlParameter) : null;
        JdbcType[] jdbcTypes = sqlParameter != null ? this.getJdbcTypes(parsedSql, sqlParameter) : null;
        return this.sqlRunner.update(connection, rawSql, parameters, jdbcTypes, generatedKey);
    }

    private List<Object[]> getArgumentsList(ParsedSql parsedSql, SqlParameters sqlParameters) {
        String[] parameterNames = parsedSql.getParameterNames();
        String[] defaultValues = parsedSql.getDefaultValues();
        ArrayList<Object[]> results = new ArrayList<Object[]>();
        for (int index = 0; index < sqlParameters.getSize(); ++index) {
            Object[] arguments = new Object[parameterNames.length];
            for (int i = 0; i < parameterNames.length; ++i) {
                arguments[i] = sqlParameters.hasValue(index, parameterNames[i]) ? sqlParameters.getValue(index, parameterNames[i]) : defaultValues[i];
            }
            results.add(arguments);
        }
        return results;
    }

    private Object[] getArguments(ParsedSql parsedSql, SqlParameter sqlParameter) {
        String[] parameterNames = parsedSql.getParameterNames();
        String[] defaultValues = parsedSql.getDefaultValues();
        Object[] arguments = new Object[parameterNames.length];
        for (int i = 0; i < parameterNames.length; ++i) {
            arguments[i] = sqlParameter.hasValue(parameterNames[i]) ? sqlParameter.getValue(parameterNames[i]) : defaultValues[i];
        }
        return arguments;
    }

    private JdbcType[] getJdbcTypes(ParsedSql parsedSql, SqlType sqlType) {
        String[] parameterNames = parsedSql.getParameterNames();
        JdbcType[] results = new JdbcType[parameterNames.length];
        int i = 0;
        for (String parameterName : parameterNames) {
            results[i++] = sqlType.getJdbcType(parameterName);
        }
        return results;
    }

    protected ParsedSql getParsedSql(String sql) {
        return ParsedSql.parse(sql);
    }

    public SqlRunner getSqlRunner() {
        return this.sqlRunner;
    }

    private static class PageableQueryImpl<T>
    extends PageableSlice<T>
    implements PageableQuery<T> {
        private final ConnectionFactory connectionFactory;
        private final PageableSql pageableSql;
        private final SqlParameter sqlParameter;
        private final RowMapper<T> rowMapper;
        private final ParsedSqlRunner sqlRunner;

        private PageableQueryImpl(ConnectionFactory connectionFactory, PageableSql pageableSql, SqlParameter sqlParameter, RowMapper<T> rowMapper, ParsedSqlRunner sqlRunner) {
            this.connectionFactory = connectionFactory;
            this.pageableSql = pageableSql;
            this.sqlParameter = sqlParameter;
            this.rowMapper = rowMapper;
            this.sqlRunner = sqlRunner;
        }

        public int rowCount() {
            String sql = this.pageableSql.countableSql();
            Connection connection = null;
            try {
                connection = this.connectionFactory.getConnection();
                int n = this.sqlRunner.queryForObject(connection, sql, this.sqlParameter, Integer.class);
                return n;
            }
            catch (SQLException e) {
                throw new PageableException(e.getMessage(), (Throwable)e);
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        public Cursor<T> cursor(int maxResults, int firstResult) {
            String sql = this.pageableSql.pageableSql(maxResults, firstResult);
            Connection connection = null;
            try {
                connection = this.connectionFactory.getConnection();
                if (SqlRunner.useCachedRowSet) {
                    return this.sqlRunner.queryForCachedCursor(connection, sql, this.sqlParameter, this.rowMapper);
                }
                return this.sqlRunner.queryForCursor(connection, sql, this.sqlParameter, this.rowMapper);
            }
            catch (SQLException e) {
                throw new PageableException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

