/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.db4j;

import com.github.paganini2008.devtools.db4j.JdbcType;
import com.github.paganini2008.devtools.db4j.TypeHandlerRegistry;
import com.github.paganini2008.devtools.db4j.TypeHandlerRegistryImpl;
import com.github.paganini2008.devtools.db4j.type.TypeHandler;
import com.github.paganini2008.devtools.jdbc.PreparedStatementCallback;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

public abstract class PreparedStatementCallbackUtils {
    public static PreparedStatementCallback batchPrepare(List<Object[]> parametersList, JdbcType[] jdbcTypes, TypeHandlerRegistry typeHandlerRegistry) {
        return new BatchArgumentJdbcTypePreparedStatementCallback(parametersList, jdbcTypes, typeHandlerRegistry);
    }

    public static PreparedStatementCallback batchPrepare(List<Object[]> parametersList, TypeHandlerRegistry typeHandlerRegistry) {
        return new BatchArgumentPreparedStatementCallback(parametersList, typeHandlerRegistry);
    }

    public static PreparedStatementCallback prepare(Object[] parameters, JdbcType[] jdbcTypes, TypeHandlerRegistry typeHandlerRegistry) {
        return new ArgumentJdbcTypePreparedStatementCallback(parameters, jdbcTypes, typeHandlerRegistry);
    }

    public static PreparedStatementCallback prepare(Object[] parameters, TypeHandlerRegistry typeHandlerRegistry) {
        return new ArgumentPreparedStatementCallback(parameters, typeHandlerRegistry);
    }

    private static class ArgumentPreparedStatementCallback
    implements PreparedStatementCallback {
        private final Object[] parameters;
        private final TypeHandlerRegistry typeHandlerRegistry;

        private ArgumentPreparedStatementCallback(Object[] parameters, TypeHandlerRegistry typeHandlerRegistry) {
            this.parameters = parameters;
            this.typeHandlerRegistry = typeHandlerRegistry;
        }

        public void setValues(PreparedStatement ps) throws SQLException {
            if (this.parameters != null && this.parameters.length > 0) {
                for (int i = 0; i < this.parameters.length; ++i) {
                    TypeHandler typeHandler = this.typeHandlerRegistry != null ? this.typeHandlerRegistry.getTypeHandler(this.parameters[i] != null ? this.parameters[i].getClass() : null, JdbcType.OTHER) : TypeHandlerRegistryImpl.getDefault();
                    typeHandler.setValue(ps, i + 1, this.parameters[i], JdbcType.OTHER);
                }
            }
        }
    }

    private static class ArgumentJdbcTypePreparedStatementCallback
    implements PreparedStatementCallback {
        private final Object[] parameters;
        private final JdbcType[] jdbcTypes;
        private final TypeHandlerRegistry typeHandlerRegistry;

        private ArgumentJdbcTypePreparedStatementCallback(Object[] parameters, JdbcType[] jdbcTypes, TypeHandlerRegistry typeHandlerRegistry) {
            this.parameters = parameters;
            this.jdbcTypes = jdbcTypes;
            this.typeHandlerRegistry = typeHandlerRegistry;
        }

        public void setValues(PreparedStatement ps) throws SQLException {
            int right;
            int left = this.parameters != null ? this.parameters.length : 0;
            int n = right = this.jdbcTypes != null ? this.jdbcTypes.length : 0;
            if (left != right) {
                throw new IllegalArgumentException("Parameters and parameter types must match.");
            }
            for (int i = 0; i < right; ++i) {
                TypeHandler typeHandler = this.typeHandlerRegistry != null ? this.typeHandlerRegistry.getTypeHandler(this.parameters[i] != null ? this.parameters[i].getClass() : null, this.jdbcTypes[i]) : TypeHandlerRegistryImpl.getDefault();
                typeHandler.setValue(ps, i + 1, this.parameters[i], this.jdbcTypes[i]);
            }
        }
    }

    private static class BatchArgumentPreparedStatementCallback
    implements PreparedStatementCallback {
        private final List<Object[]> parametersList;
        private final TypeHandlerRegistry typeHandlerRegistry;

        private BatchArgumentPreparedStatementCallback(List<Object[]> parametersList, TypeHandlerRegistry typeHandlerRegistry) {
            this.parametersList = parametersList;
            this.typeHandlerRegistry = typeHandlerRegistry;
        }

        public void setValues(PreparedStatement ps) throws SQLException {
            if (this.parametersList != null && this.parametersList.size() > 0) {
                for (int i = 0; i < this.parametersList.size(); ++i) {
                    Object[] parameters = this.parametersList.get(i);
                    if (parameters == null || parameters.length <= 0) continue;
                    for (int j = 0; j < parameters.length; ++j) {
                        TypeHandler typeHandler = this.typeHandlerRegistry != null ? this.typeHandlerRegistry.getTypeHandler(parameters[j] != null ? parameters[j].getClass() : null, JdbcType.OTHER) : TypeHandlerRegistryImpl.getDefault();
                        typeHandler.setValue(ps, j + 1, parameters[j], JdbcType.OTHER);
                    }
                    ps.addBatch();
                }
            }
        }
    }

    private static class BatchArgumentJdbcTypePreparedStatementCallback
    implements PreparedStatementCallback {
        private final List<Object[]> parametersList;
        private final JdbcType[] jdbcTypes;
        private final TypeHandlerRegistry typeHandlerRegistry;

        private BatchArgumentJdbcTypePreparedStatementCallback(List<Object[]> parametersList, JdbcType[] jdbcTypes, TypeHandlerRegistry typeHandlerRegistry) {
            this.parametersList = parametersList;
            this.jdbcTypes = jdbcTypes;
            this.typeHandlerRegistry = typeHandlerRegistry;
        }

        public void setValues(PreparedStatement ps) throws SQLException {
            if (this.parametersList != null && this.parametersList.size() > 0) {
                int right = this.jdbcTypes != null ? this.jdbcTypes.length : 0;
                for (int i = 0; i < this.parametersList.size(); ++i) {
                    int left;
                    Object[] parameters = this.parametersList.get(i);
                    int n = left = parameters != null ? parameters.length : 0;
                    if (left != right) {
                        throw new IllegalArgumentException("Parameters and parameter types must match.");
                    }
                    for (int j = 0; j < right; ++j) {
                        TypeHandler typeHandler = this.typeHandlerRegistry != null ? this.typeHandlerRegistry.getTypeHandler(parameters[j] != null ? parameters[j].getClass() : null, this.jdbcTypes[j]) : TypeHandlerRegistryImpl.getDefault();
                        typeHandler.setValue(ps, j + 1, parameters[j], this.jdbcTypes[j]);
                    }
                    ps.addBatch();
                }
            }
        }
    }
}

