/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.db4j;

import com.github.paganini2008.devtools.db4j.PreparedStatementCreator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public abstract class PreparedStatementCreatorUtils {
    public static PreparedStatementCreator forDefault(String sql) {
        return new DefaultPreparedStatementCreator(sql);
    }

    public static PreparedStatementCreator forColumnNames(String sql, String[] columnNames) {
        return new ColumnNamesPreparedStatementCreator(sql, columnNames);
    }

    public static PreparedStatementCreator forColumnIndexes(String sql, int[] columnIndexes) {
        return new ColumnIndexesPreparedStatementCreator(sql, columnIndexes);
    }

    public static PreparedStatementCreator forGeneratedKey(String sql) {
        return new GeneratedKeyPreparedStatementCreator(sql);
    }

    public static PreparedStatementCreator forQuery(String sql, int resultSetType, int resultSetConcurrency) {
        return new ResultSetPreparedStatementCreator(sql, resultSetType, resultSetConcurrency);
    }

    private static class ResultSetPreparedStatementCreator
    implements PreparedStatementCreator {
        private final String sql;
        private final int resultSetType;
        private final int resultSetConcurrency;

        private ResultSetPreparedStatementCreator(String sql, int resultSetType, int resultSetConcurrency) {
            this.sql = sql;
            this.resultSetType = resultSetType;
            this.resultSetConcurrency = resultSetConcurrency;
        }

        @Override
        public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
            return connection.prepareStatement(this.sql, this.resultSetType, this.resultSetConcurrency);
        }
    }

    private static class GeneratedKeyPreparedStatementCreator
    implements PreparedStatementCreator {
        private final String sql;

        private GeneratedKeyPreparedStatementCreator(String sql) {
            this.sql = sql;
        }

        @Override
        public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
            return connection.prepareStatement(this.sql, 1);
        }
    }

    private static class ColumnIndexesPreparedStatementCreator
    implements PreparedStatementCreator {
        private final String sql;
        private final int[] columnIndexes;

        private ColumnIndexesPreparedStatementCreator(String sql, int[] columnIndexes) {
            this.sql = sql;
            this.columnIndexes = columnIndexes;
        }

        @Override
        public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
            return connection.prepareStatement(this.sql, this.columnIndexes);
        }
    }

    private static class ColumnNamesPreparedStatementCreator
    implements PreparedStatementCreator {
        private final String sql;
        private final String[] columnNames;

        private ColumnNamesPreparedStatementCreator(String sql, String[] columnNames) {
            this.sql = sql;
            this.columnNames = columnNames;
        }

        @Override
        public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
            return connection.prepareStatement(this.sql, this.columnNames);
        }
    }

    private static class DefaultPreparedStatementCreator
    implements PreparedStatementCreator {
        private final String sql;

        private DefaultPreparedStatementCreator(String sql) {
            this.sql = sql;
        }

        @Override
        public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
            return connection.prepareStatement(this.sql);
        }
    }
}

