/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.db4j;

import com.github.paganini2008.devtools.db4j.ResultSetExtractor;
import com.github.paganini2008.devtools.db4j.TypeHandlerRegistry;
import com.github.paganini2008.devtools.db4j.mapper.RowMapper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class RowMapperResultSetExtractor<T>
implements ResultSetExtractor<List<T>> {
    private final RowMapper<T> rowMapper;
    private final TypeHandlerRegistry typeHandlerRegistry;

    public RowMapperResultSetExtractor(RowMapper<T> rowMapper, TypeHandlerRegistry typeHandlerRegistry) {
        if (rowMapper == null) {
            throw new IllegalArgumentException("RowMapper must not be null.");
        }
        this.rowMapper = rowMapper;
        this.typeHandlerRegistry = typeHandlerRegistry;
    }

    @Override
    public List<T> extractData(ResultSet rs) throws SQLException {
        ArrayList<T> results = new ArrayList<T>();
        int rownum = 1;
        while (rs.next()) {
            results.add(this.rowMapper.mapRow(rownum++, rs, this.typeHandlerRegistry));
        }
        return results;
    }
}

