/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.db4j;

import com.github.paganini2008.devtools.collection.Tuple;
import com.github.paganini2008.devtools.db4j.ConnectionSettings;
import com.github.paganini2008.devtools.db4j.Customizable;
import com.github.paganini2008.devtools.db4j.GeneratedKey;
import com.github.paganini2008.devtools.db4j.JdbcOperations;
import com.github.paganini2008.devtools.db4j.ParsedSqlRunner;
import com.github.paganini2008.devtools.db4j.ResultSetExtractor;
import com.github.paganini2008.devtools.db4j.SqlParameter;
import com.github.paganini2008.devtools.db4j.SqlParameters;
import com.github.paganini2008.devtools.db4j.Transaction;
import com.github.paganini2008.devtools.db4j.TransactionImpl;
import com.github.paganini2008.devtools.db4j.mapper.RowMapper;
import com.github.paganini2008.devtools.jdbc.ConnectionFactory;
import com.github.paganini2008.devtools.jdbc.Cursor;
import com.github.paganini2008.devtools.jdbc.JdbcUtils;
import com.github.paganini2008.devtools.jdbc.PageableQuery;
import com.github.paganini2008.devtools.jdbc.PageableSql;
import com.github.paganini2008.devtools.jdbc.PooledConnectionFactory;
import com.github.paganini2008.devtools.jdbc.UnpooledConnectionFactory;
import com.github.paganini2008.devtools.jdbc.UnpooledDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;

public class SqlPlus
implements JdbcOperations {
    private final ConnectionFactory connectionFactory;
    private final ParsedSqlRunner sqlRunner;

    public SqlPlus(String driverClassName, String jdbcUrl, String user, String password, int poolSize) {
        this((DataSource)new UnpooledDataSource(driverClassName, jdbcUrl, user, password, poolSize));
    }

    public SqlPlus(String driverClassName, String jdbcUrl, String user, String password) {
        this((ConnectionFactory)new UnpooledConnectionFactory(driverClassName, jdbcUrl, user, password));
    }

    public SqlPlus(DataSource dataSource) {
        this((ConnectionFactory)new PooledConnectionFactory(dataSource));
    }

    public SqlPlus(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
        this.sqlRunner = new ParsedSqlRunner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update(String sql, SqlParameter sqlParameter) throws SQLException {
        Connection connection = this.getConnection();
        try {
            int n = this.sqlRunner.update(connection, sql, sqlParameter);
            return n;
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update(String sql, SqlParameter sqlParameter, GeneratedKey generatedKey) throws SQLException {
        Connection connection = this.getConnection();
        try {
            int n = this.sqlRunner.update(connection, sql, sqlParameter, generatedKey);
            return n;
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] batchUpdate(String sql, SqlParameters sqlParameters) throws SQLException {
        Connection connection = this.getConnection();
        try {
            int[] nArray = this.sqlRunner.batchUpdate(connection, sql, sqlParameters);
            return nArray;
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T query(String sql, SqlParameter sqlParameter, ResultSetExtractor<T> extractor) throws SQLException {
        Connection connection = this.getConnection();
        try {
            T t = this.sqlRunner.query(connection, sql, sqlParameter, extractor);
            return t;
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Tuple> queryForList(String sql, SqlParameter sqlParameter) throws SQLException {
        Connection connection = this.getConnection();
        try {
            List<Tuple> list = this.sqlRunner.queryForList(connection, sql, sqlParameter);
            return list;
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T queryForObject(String sql, SqlParameter sqlParameter, RowMapper<T> rowMapper) throws SQLException {
        Connection connection = this.getConnection();
        try {
            T t = this.sqlRunner.queryForObject(connection, sql, sqlParameter, rowMapper);
            return t;
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> queryForList(String sql, SqlParameter sqlParameter, RowMapper<T> rowMapper) throws SQLException {
        Connection connection = this.getConnection();
        try {
            List<T> list = this.sqlRunner.queryForList(connection, sql, sqlParameter, rowMapper);
            return list;
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Cursor<T> queryForCursor(String sql, SqlParameter sqlParameter, RowMapper<T> rowMapper) throws SQLException {
        Connection connection = this.getConnection();
        try {
            Cursor<T> cursor = this.sqlRunner.queryForCursor(connection, sql, sqlParameter, rowMapper);
            return cursor;
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Cursor<T> queryForCachedCursor(String sql, SqlParameter sqlParameter, RowMapper<T> rowMapper) throws SQLException {
        Connection connection = this.getConnection();
        try {
            Cursor<T> cursor = this.sqlRunner.queryForCachedCursor(connection, sql, sqlParameter, rowMapper);
            return cursor;
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    @Override
    public PageableQuery<Tuple> queryForPage(PageableSql pageableSql, SqlParameter sqlParameter) throws SQLException {
        return this.sqlRunner.queryForPage(this.connectionFactory, pageableSql, sqlParameter);
    }

    @Override
    public <T> PageableQuery<T> queryForPage(PageableSql pageableSql, SqlParameter sqlParameter, RowMapper<T> rowMapper) throws SQLException {
        return this.sqlRunner.queryForPage(this.connectionFactory, pageableSql, sqlParameter, rowMapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T customize(Customizable<T> customizable) throws SQLException {
        Connection connection = this.getConnection();
        try {
            T t = customizable.customize(connection, this.sqlRunner);
            return t;
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    protected Connection getConnection() throws SQLException {
        return this.connectionFactory.getConnection();
    }

    public Transaction beginTransaction() throws SQLException {
        return this.beginTransaction(connection -> {});
    }

    public Transaction beginTransaction(ConnectionSettings connectionSettings) throws SQLException {
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        if (connectionSettings != null) {
            connectionSettings.applySettings(connection);
        }
        return new TransactionImpl(connection, this.sqlRunner);
    }

    public ParsedSqlRunner getSqlRunner() {
        return this.sqlRunner;
    }
}

