/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.db4j;

import com.github.paganini2008.devtools.ArrayUtils;
import com.github.paganini2008.devtools.Observable;
import com.github.paganini2008.devtools.Observer;
import com.github.paganini2008.devtools.collection.Tuple;
import com.github.paganini2008.devtools.db4j.CachedCursorResultSetExtractor;
import com.github.paganini2008.devtools.db4j.CursorResultSetExtractor;
import com.github.paganini2008.devtools.db4j.FirstRowResultSetExtractor;
import com.github.paganini2008.devtools.db4j.GeneratedKey;
import com.github.paganini2008.devtools.db4j.JdbcType;
import com.github.paganini2008.devtools.db4j.PreparedStatementCallbackUtils;
import com.github.paganini2008.devtools.db4j.PreparedStatementCreator;
import com.github.paganini2008.devtools.db4j.PreparedStatementCreatorUtils;
import com.github.paganini2008.devtools.db4j.PreparedStatementExecutor;
import com.github.paganini2008.devtools.db4j.ResultSetExtractor;
import com.github.paganini2008.devtools.db4j.RowMapperResultSetExtractor;
import com.github.paganini2008.devtools.db4j.TypeHandlerRegistry;
import com.github.paganini2008.devtools.db4j.TypeHandlerRegistryImpl;
import com.github.paganini2008.devtools.db4j.mapper.BeanPropertyRowMapper;
import com.github.paganini2008.devtools.db4j.mapper.ColumnIndexRowMapper;
import com.github.paganini2008.devtools.db4j.mapper.RowMapper;
import com.github.paganini2008.devtools.db4j.mapper.TupleRowMapper;
import com.github.paganini2008.devtools.jdbc.ConnectionFactory;
import com.github.paganini2008.devtools.jdbc.Cursor;
import com.github.paganini2008.devtools.jdbc.DefaultPageableSql;
import com.github.paganini2008.devtools.jdbc.JdbcUtils;
import com.github.paganini2008.devtools.jdbc.PageableException;
import com.github.paganini2008.devtools.jdbc.PageableQuery;
import com.github.paganini2008.devtools.jdbc.PageableSlice;
import com.github.paganini2008.devtools.jdbc.PageableSql;
import com.github.paganini2008.devtools.jdbc.PreparedStatementCallback;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class SqlRunner {
    private TypeHandlerRegistry typeHandlerRegistry = new TypeHandlerRegistryImpl();
    static boolean useCachedRowSet = true;

    public TypeHandlerRegistry getTypeHandlerRegistry() {
        return this.typeHandlerRegistry;
    }

    public <T> T query(Connection connection, String sql, Object[] parameters, ResultSetExtractor<T> extractor) throws SQLException {
        return this.query(connection, sql, PreparedStatementCallbackUtils.prepare(parameters, this.typeHandlerRegistry), extractor);
    }

    public <T> T query(Connection connection, String sql, Object[] parameters, JdbcType[] jdbcTypes, ResultSetExtractor<T> extractor) throws SQLException {
        return this.query(connection, sql, PreparedStatementCallbackUtils.prepare(parameters, jdbcTypes, this.typeHandlerRegistry), extractor);
    }

    public <T> T query(Connection connection, String sql, PreparedStatementCallback callback, ResultSetExtractor<T> extractor) throws SQLException {
        return this.query(connection, PreparedStatementCreatorUtils.forQuery(sql, 1003, 1007), callback, extractor);
    }

    public <T> T query(Connection connection, PreparedStatementCreator statementCreator, final PreparedStatementCallback callback, final ResultSetExtractor<T> extractor) throws SQLException {
        return this.execute(connection, statementCreator, new PreparedStatementExecutor<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T execute(PreparedStatement ps) throws SQLException {
                if (callback != null) {
                    callback.setValues(ps);
                }
                ResultSet rs = null;
                try {
                    rs = ps.executeQuery();
                    Object t = extractor.extractData(rs);
                    return t;
                }
                finally {
                    JdbcUtils.closeQuietly((ResultSet)rs);
                }
            }

            @Override
            public void close(PreparedStatement ps) {
                JdbcUtils.closeQuietly((Statement)ps);
            }
        });
    }

    public <T> T queryForObject(Connection connection, String sql, Object[] parameters, Class<T> requiredType) throws SQLException {
        return this.queryForObject(connection, sql, PreparedStatementCallbackUtils.prepare(parameters, this.typeHandlerRegistry), requiredType);
    }

    public <T> T queryForObject(Connection connection, String sql, Object[] parameters, JdbcType[] jdbcTypes, Class<T> requiredType) throws SQLException {
        return this.queryForObject(connection, sql, PreparedStatementCallbackUtils.prepare(parameters, jdbcTypes, this.typeHandlerRegistry), requiredType);
    }

    public <T> T queryForObject(Connection connection, String sql, PreparedStatementCallback callback, Class<T> requiredType) throws SQLException {
        return this.queryForObject(connection, PreparedStatementCreatorUtils.forDefault(sql), callback, requiredType);
    }

    public <T> T queryForObject(Connection connection, PreparedStatementCreator statementCreator, PreparedStatementCallback callback, Class<T> requiredType) throws SQLException {
        return this.queryForObject(connection, statementCreator, callback, new ColumnIndexRowMapper<T>(requiredType));
    }

    public <T> T queryForObject(Connection connection, String sql, Object[] parameters, RowMapper<T> rowMapper) throws SQLException {
        return this.queryForObject(connection, sql, PreparedStatementCallbackUtils.prepare(parameters, this.typeHandlerRegistry), rowMapper);
    }

    public <T> T queryForObject(Connection connection, String sql, Object[] parameters, JdbcType[] jdbcTypes, RowMapper<T> rowMapper) throws SQLException {
        return this.queryForObject(connection, sql, PreparedStatementCallbackUtils.prepare(parameters, jdbcTypes, this.typeHandlerRegistry), rowMapper);
    }

    public <T> T queryForObject(Connection connection, String sql, PreparedStatementCallback callback, RowMapper<T> rowMapper) throws SQLException {
        return this.queryForObject(connection, PreparedStatementCreatorUtils.forDefault(sql), callback, rowMapper);
    }

    public <T> T queryForObject(Connection connection, PreparedStatementCreator statementCreator, PreparedStatementCallback callback, RowMapper<T> rowMapper) throws SQLException {
        return this.query(connection, statementCreator, callback, new FirstRowResultSetExtractor<T>(rowMapper, this.typeHandlerRegistry));
    }

    public Tuple queryForTuple(Connection connection, String sql, Object[] parameters) throws SQLException {
        return this.queryForTuple(connection, sql, PreparedStatementCallbackUtils.prepare(parameters, this.typeHandlerRegistry));
    }

    public Tuple queryForTuple(Connection connection, String sql, Object[] parameters, JdbcType[] jdbcTypes) throws SQLException {
        return this.queryForTuple(connection, sql, PreparedStatementCallbackUtils.prepare(parameters, jdbcTypes, this.typeHandlerRegistry));
    }

    public Tuple queryForTuple(Connection connection, String sql, PreparedStatementCallback callback) throws SQLException {
        return this.queryForTuple(connection, PreparedStatementCreatorUtils.forDefault(sql), callback);
    }

    public Tuple queryForTuple(Connection connection, PreparedStatementCreator statementCreator, PreparedStatementCallback callback) throws SQLException {
        return this.queryForObject(connection, statementCreator, callback, new TupleRowMapper());
    }

    public <T> List<T> queryForList(Connection connection, String sql, Object[] parameters, RowMapper<T> rowMapper) throws SQLException {
        return this.queryForList(connection, sql, PreparedStatementCallbackUtils.prepare(parameters, this.typeHandlerRegistry), rowMapper);
    }

    public <T> List<T> queryForList(Connection connection, String sql, Object[] parameters, JdbcType[] jdbcTypes, RowMapper<T> rowMapper) throws SQLException {
        return this.queryForList(connection, sql, PreparedStatementCallbackUtils.prepare(parameters, jdbcTypes, this.typeHandlerRegistry), rowMapper);
    }

    public <T> List<T> queryForList(Connection connection, String sql, PreparedStatementCallback callback, RowMapper<T> rowMapper) throws SQLException {
        return this.queryForList(connection, PreparedStatementCreatorUtils.forQuery(sql, 1003, 1007), callback, rowMapper);
    }

    public <T> List<T> queryForList(Connection connection, PreparedStatementCreator statementCreator, PreparedStatementCallback callback, RowMapper<T> rowMapper) throws SQLException {
        return (List)this.query(connection, statementCreator, callback, new RowMapperResultSetExtractor<T>(rowMapper, this.typeHandlerRegistry));
    }

    public List<Tuple> queryForList(Connection connection, String sql, Object[] parameters) throws SQLException {
        return this.queryForList(connection, sql, PreparedStatementCallbackUtils.prepare(parameters, this.typeHandlerRegistry), new TupleRowMapper());
    }

    public List<Tuple> queryForList(Connection connection, String sql, Object[] parameters, JdbcType[] jdbcTypes) throws SQLException {
        return this.queryForList(connection, sql, PreparedStatementCallbackUtils.prepare(parameters, jdbcTypes, this.typeHandlerRegistry), new TupleRowMapper());
    }

    public List<Tuple> queryForList(Connection connection, String sql, PreparedStatementCallback callback) throws SQLException {
        return this.queryForList(connection, PreparedStatementCreatorUtils.forQuery(sql, 1003, 1007), callback, new TupleRowMapper());
    }

    public List<Tuple> queryForList(Connection connection, PreparedStatementCreator statementCreator, PreparedStatementCallback callback) throws SQLException {
        return this.queryForList(connection, statementCreator, callback, new TupleRowMapper());
    }

    public <T> List<T> queryForList(Connection connection, String sql, Object[] parameters, Class<T> objectClass) throws SQLException {
        return this.queryForList(connection, sql, PreparedStatementCallbackUtils.prepare(parameters, this.typeHandlerRegistry), objectClass);
    }

    public <T> List<T> queryForList(Connection connection, String sql, Object[] parameters, JdbcType[] jdbcTypes, Class<T> objectClass) throws SQLException {
        return this.queryForList(connection, sql, PreparedStatementCallbackUtils.prepare(parameters, jdbcTypes, this.typeHandlerRegistry), objectClass);
    }

    public <T> List<T> queryForList(Connection connection, String sql, PreparedStatementCallback callback, Class<T> objectClass) throws SQLException {
        return this.queryForList(connection, PreparedStatementCreatorUtils.forQuery(sql, 1003, 1007), callback, objectClass);
    }

    public <T> List<T> queryForList(Connection connection, PreparedStatementCreator statementCreator, PreparedStatementCallback callback, Class<T> objectClass) throws SQLException {
        return this.queryForList(connection, statementCreator, callback, new BeanPropertyRowMapper<T>(objectClass));
    }

    public Cursor<Tuple> queryForCursor(Connection connection, String sql, Object[] parameters) throws SQLException {
        return this.queryForCursor(connection, sql, PreparedStatementCallbackUtils.prepare(parameters, this.typeHandlerRegistry));
    }

    public Cursor<Tuple> queryForCursor(Connection connection, String sql, Object[] parameters, JdbcType[] jdbcTypes) throws SQLException {
        return this.queryForCursor(connection, sql, PreparedStatementCallbackUtils.prepare(parameters, jdbcTypes, this.typeHandlerRegistry));
    }

    public Cursor<Tuple> queryForCursor(Connection connection, String sql) throws SQLException {
        return this.queryForCursor(connection, sql, (PreparedStatementCallback)null);
    }

    public Cursor<Tuple> queryForCursor(Connection connection, String sql, PreparedStatementCallback callback) throws SQLException {
        return this.queryForCursor(connection, PreparedStatementCreatorUtils.forQuery(sql, 1003, 1007), callback, new TupleRowMapper());
    }

    public <T> Cursor<T> queryForCursor(Connection connection, String sql, Object[] parameters, Class<T> objectClass) throws SQLException {
        return this.queryForCursor(connection, sql, PreparedStatementCallbackUtils.prepare(parameters, this.typeHandlerRegistry), new BeanPropertyRowMapper<T>(objectClass));
    }

    public <T> Cursor<T> queryForCursor(Connection connection, String sql, Object[] parameters, JdbcType[] jdbcTypes, Class<T> objectClass) throws SQLException {
        return this.queryForCursor(connection, sql, PreparedStatementCallbackUtils.prepare(parameters, jdbcTypes, this.typeHandlerRegistry), new BeanPropertyRowMapper<T>(objectClass));
    }

    public <T> Cursor<T> queryForCursor(Connection connection, String sql, PreparedStatementCallback callback, Class<T> objectClass) throws SQLException {
        return this.queryForCursor(connection, sql, callback, new BeanPropertyRowMapper<T>(objectClass));
    }

    public <T> Cursor<T> queryForCursor(Connection connection, String sql, Object[] parameters, RowMapper<T> rowMapper) throws SQLException {
        return this.queryForCursor(connection, sql, PreparedStatementCallbackUtils.prepare(parameters, this.typeHandlerRegistry), rowMapper);
    }

    public <T> Cursor<T> queryForCursor(Connection connection, String sql, Object[] parameters, JdbcType[] jdbcTypes, RowMapper<T> rowMapper) throws SQLException {
        return this.queryForCursor(connection, sql, PreparedStatementCallbackUtils.prepare(parameters, jdbcTypes, this.typeHandlerRegistry), rowMapper);
    }

    public <T> Cursor<T> queryForCursor(Connection connection, String sql, PreparedStatementCallback callback, RowMapper<T> rowMapper) throws SQLException {
        return this.queryForCursor(connection, PreparedStatementCreatorUtils.forQuery(sql, 1004, 1007), callback, rowMapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Cursor<T> queryForCursor(Connection connection, PreparedStatementCreator statementCreator, final PreparedStatementCallback callback, final RowMapper<T> rowMapper) throws SQLException {
        Cursor cursor;
        block5: {
            block4: {
                final Observable closeable = Observable.unrepeatable();
                final AtomicBoolean success = new AtomicBoolean(true);
                try {
                    cursor = (Cursor)this.execute(connection, statementCreator, new PreparedStatementExecutor<Cursor<T>>(){

                        @Override
                        public Cursor<T> execute(PreparedStatement ps) throws SQLException {
                            Cursor cursor;
                            block8: {
                                ResultSet rs;
                                block7: {
                                    ResultSet ref;
                                    if (callback != null) {
                                        callback.setValues(ps);
                                    }
                                    rs = null;
                                    try {
                                        rs = ps.executeQuery();
                                        CursorResultSetExtractor extractor = new CursorResultSetExtractor(rowMapper, SqlRunner.this.typeHandlerRegistry, closeable);
                                        cursor = (Cursor)extractor.extractData(rs);
                                        if (!success.get()) break block7;
                                        ref = rs;
                                    }
                                    catch (SQLException e) {
                                        try {
                                            success.set(false);
                                            throw e;
                                        }
                                        catch (Throwable throwable) {
                                            if (success.get()) {
                                                ResultSet ref2 = rs;
                                                closeable.addObserver(new Observer(ref2){
                                                    final /* synthetic */ ResultSet val$ref;
                                                    {
                                                        this.val$ref = resultSet;
                                                    }

                                                    public void update(Observable o, Object arg) {
                                                        JdbcUtils.closeQuietly((ResultSet)this.val$ref);
                                                    }
                                                });
                                            } else {
                                                JdbcUtils.closeQuietly((ResultSet)rs);
                                            }
                                            throw throwable;
                                        }
                                    }
                                    closeable.addObserver(new /* invalid duplicate definition of identical inner class */);
                                    break block8;
                                }
                                JdbcUtils.closeQuietly((ResultSet)rs);
                            }
                            return cursor;
                        }

                        @Override
                        public void close(final PreparedStatement ps) {
                            if (success.get()) {
                                closeable.addObserver(new Observer(){

                                    public void update(Observable o, Object arg) {
                                        JdbcUtils.closeQuietly((Statement)ps);
                                    }
                                });
                            } else {
                                JdbcUtils.closeQuietly((Statement)ps);
                            }
                        }
                    });
                    if (!success.get()) break block4;
                }
                catch (Throwable throwable) {
                    if (success.get()) {
                        closeable.addObserver(new Observer(connection){
                            final /* synthetic */ Connection val$connection;
                            {
                                this.val$connection = connection;
                            }

                            public void update(Observable o, Object arg) {
                                JdbcUtils.closeQuietly((Connection)this.val$connection);
                            }
                        });
                    } else {
                        JdbcUtils.closeQuietly((Connection)connection);
                    }
                    throw throwable;
                }
                closeable.addObserver(new /* invalid duplicate definition of identical inner class */);
                break block5;
            }
            JdbcUtils.closeQuietly((Connection)connection);
        }
        return cursor;
    }

    public Cursor<Tuple> queryForCachedCursor(Connection connection, String sql, Object[] parameters) throws SQLException {
        return this.queryForCachedCursor(connection, sql, PreparedStatementCallbackUtils.prepare(parameters, this.typeHandlerRegistry));
    }

    public Cursor<Tuple> queryForCachedCursor(Connection connection, String sql, Object[] parameters, JdbcType[] jdbcTypes) throws SQLException {
        return this.queryForCachedCursor(connection, sql, PreparedStatementCallbackUtils.prepare(parameters, jdbcTypes, this.typeHandlerRegistry));
    }

    public Cursor<Tuple> queryForCachedCursor(Connection connection, String sql) throws SQLException {
        return this.queryForCachedCursor(connection, sql, (PreparedStatementCallback)null);
    }

    public Cursor<Tuple> queryForCachedCursor(Connection connection, String sql, PreparedStatementCallback callback) throws SQLException {
        return this.queryForCachedCursor(connection, sql, callback, new TupleRowMapper());
    }

    public <T> Cursor<T> queryForCachedCursor(Connection connection, String sql, Object[] parameters, RowMapper<T> rowMapper) throws SQLException {
        return this.queryForCachedCursor(connection, sql, PreparedStatementCallbackUtils.prepare(parameters, this.typeHandlerRegistry), rowMapper);
    }

    public <T> Cursor<T> queryForCachedCursor(Connection connection, String sql, Object[] parameters, JdbcType[] jdbcTypes, RowMapper<T> rowMapper) throws SQLException {
        return this.queryForCachedCursor(connection, sql, PreparedStatementCallbackUtils.prepare(parameters, jdbcTypes, this.typeHandlerRegistry), rowMapper);
    }

    public <T> Cursor<T> queryForCachedCursor(Connection connection, String sql, PreparedStatementCallback callback, RowMapper<T> rowMapper) throws SQLException {
        return this.queryForCachedCursor(connection, PreparedStatementCreatorUtils.forQuery(sql, 1005, 1007), callback, rowMapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Cursor<T> queryForCachedCursor(Connection connection, PreparedStatementCreator statementCreator, final PreparedStatementCallback callback, final RowMapper<T> rowMapper) throws SQLException {
        try {
            Cursor cursor = (Cursor)this.execute(connection, statementCreator, new PreparedStatementExecutor<Cursor<T>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Cursor<T> execute(PreparedStatement ps) throws SQLException {
                    if (callback != null) {
                        callback.setValues(ps);
                    }
                    ResultSet rs = null;
                    try {
                        rs = ps.executeQuery();
                        CachedCursorResultSetExtractor extractor = new CachedCursorResultSetExtractor(rowMapper, SqlRunner.this.typeHandlerRegistry);
                        Cursor cursor = (Cursor)extractor.extractData(rs);
                        return cursor;
                    }
                    finally {
                        JdbcUtils.closeQuietly((ResultSet)rs);
                    }
                }

                @Override
                public void close(PreparedStatement ps) {
                    JdbcUtils.closeQuietly((Statement)ps);
                }
            });
            return cursor;
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    public <T> PageableQuery<T> queryForPage(ConnectionFactory connectionFactory, String sql, Object[] parameters, RowMapper<T> rowMapper) {
        return new PageableQueryImpl(connectionFactory, (PageableSql)new DefaultPageableSql(sql), PreparedStatementCallbackUtils.prepare(parameters, this.typeHandlerRegistry), rowMapper, this);
    }

    public <T> PageableQuery<T> queryForPage(ConnectionFactory connectionFactory, String sql, Object[] parameters, JdbcType[] jdbcTypes, RowMapper<T> rowMapper) {
        return new PageableQueryImpl(connectionFactory, (PageableSql)new DefaultPageableSql(sql), PreparedStatementCallbackUtils.prepare(parameters, jdbcTypes, this.typeHandlerRegistry), rowMapper, this);
    }

    public <T> PageableQuery<T> queryForPage(ConnectionFactory connectionFactory, String sql, PreparedStatementCallback callback, RowMapper<T> rowMapper) {
        return new PageableQueryImpl(connectionFactory, (PageableSql)new DefaultPageableSql(sql), callback, rowMapper, this);
    }

    public <T> PageableQuery<T> queryForPage(ConnectionFactory connectionFactory, PageableSql pageableSql, PreparedStatementCallback callback, RowMapper<T> rowMapper) {
        return new PageableQueryImpl(connectionFactory, pageableSql, callback, rowMapper, this);
    }

    public PageableQuery<Tuple> queryForPage(ConnectionFactory connectionFactory, String sql, Object[] parameters, JdbcType[] jdbcTypes) {
        return this.queryForPage(connectionFactory, sql, PreparedStatementCallbackUtils.prepare(parameters, jdbcTypes, this.typeHandlerRegistry));
    }

    public PageableQuery<Tuple> queryForPage(ConnectionFactory connectionFactory, String sql, Object[] parameters) {
        return this.queryForPage(connectionFactory, sql, PreparedStatementCallbackUtils.prepare(parameters, this.typeHandlerRegistry));
    }

    public PageableQuery<Tuple> queryForPage(ConnectionFactory connectionFactory, String sql, PreparedStatementCallback callback) {
        return this.queryForPage(connectionFactory, (PageableSql)new DefaultPageableSql(sql), callback);
    }

    public PageableQuery<Tuple> queryForPage(ConnectionFactory connectionFactory, PageableSql pageableSql, PreparedStatementCallback callback) {
        return this.queryForPage(connectionFactory, pageableSql, callback, new TupleRowMapper());
    }

    public int update(Connection connection, String sql, Object[] parameters, GeneratedKey generatedKey) throws SQLException {
        return this.update(connection, sql, PreparedStatementCallbackUtils.prepare(parameters, this.typeHandlerRegistry), generatedKey);
    }

    public int update(Connection connection, String sql, Object[] parameters, JdbcType[] jdbcTypes, GeneratedKey generatedKey) throws SQLException {
        return this.update(connection, sql, PreparedStatementCallbackUtils.prepare(parameters, jdbcTypes, this.typeHandlerRegistry), generatedKey);
    }

    public int update(Connection connection, String sql, PreparedStatementCallback callback, GeneratedKey generatedKey) throws SQLException {
        return this.update(connection, ArrayUtils.isNotEmpty((Object[])generatedKey.getKeyNames()) ? PreparedStatementCreatorUtils.forColumnNames(sql, generatedKey.getKeyNames()) : PreparedStatementCreatorUtils.forGeneratedKey(sql), callback, generatedKey);
    }

    public int update(Connection connection, PreparedStatementCreator statementCreator, final PreparedStatementCallback callback, final GeneratedKey generatedKey) throws SQLException {
        return this.execute(connection, statementCreator, new PreparedStatementExecutor<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer execute(PreparedStatement ps) throws SQLException {
                ResultSet rs;
                int effected;
                if (callback != null) {
                    callback.setValues(ps);
                }
                if ((effected = ps.executeUpdate()) > 0 && (rs = ps.getGeneratedKeys()) != null) {
                    try {
                        FirstRowResultSetExtractor<Tuple> extractor = new FirstRowResultSetExtractor<Tuple>(new TupleRowMapper(), SqlRunner.this.typeHandlerRegistry);
                        Tuple keys = (Tuple)extractor.extractData(rs);
                        if (keys != null) {
                            generatedKey.setKeys((Map)keys);
                        }
                    }
                    finally {
                        JdbcUtils.closeQuietly((ResultSet)rs);
                    }
                }
                return effected;
            }

            @Override
            public void close(PreparedStatement ps) {
                JdbcUtils.closeQuietly((Statement)ps);
            }
        });
    }

    public int update(Connection connection, String sql, Object[] parameters) throws SQLException {
        return this.update(connection, sql, PreparedStatementCallbackUtils.prepare(parameters, this.typeHandlerRegistry));
    }

    public int update(Connection connection, String sql, Object[] parameters, JdbcType[] jdbcTypes) throws SQLException {
        return this.update(connection, sql, PreparedStatementCallbackUtils.prepare(parameters, jdbcTypes, this.typeHandlerRegistry));
    }

    public int update(Connection connection, String sql, PreparedStatementCallback callback) throws SQLException {
        return this.update(connection, PreparedStatementCreatorUtils.forDefault(sql), callback);
    }

    public int update(Connection connection, PreparedStatementCreator statementCreator, final PreparedStatementCallback callback) throws SQLException {
        return this.execute(connection, statementCreator, new PreparedStatementExecutor<Integer>(){

            @Override
            public Integer execute(PreparedStatement ps) throws SQLException {
                if (callback != null) {
                    callback.setValues(ps);
                }
                return ps.executeUpdate();
            }

            @Override
            public void close(PreparedStatement ps) {
                JdbcUtils.closeQuietly((Statement)ps);
            }
        });
    }

    public int[] batchUpdate(Connection connection, String sql, List<Object[]> parameters, JdbcType[] jdbcTypes) throws SQLException {
        return this.batchUpdate(connection, sql, PreparedStatementCallbackUtils.batchPrepare(parameters, jdbcTypes, this.typeHandlerRegistry));
    }

    public int[] batchUpdate(Connection connection, String sql, List<Object[]> parameters) throws SQLException {
        return this.batchUpdate(connection, sql, PreparedStatementCallbackUtils.batchPrepare(parameters, this.typeHandlerRegistry));
    }

    public int[] batchUpdate(Connection connection, String sql, PreparedStatementCallback callback) throws SQLException {
        return this.batchUpdate(connection, PreparedStatementCreatorUtils.forDefault(sql), callback);
    }

    public int[] batchUpdate(Connection connection, PreparedStatementCreator statementCreator, final PreparedStatementCallback callback) throws SQLException {
        return this.execute(connection, statementCreator, new PreparedStatementExecutor<int[]>(){

            @Override
            public int[] execute(PreparedStatement ps) throws SQLException {
                if (callback != null) {
                    callback.setValues(ps);
                }
                return ps.executeBatch();
            }

            @Override
            public void close(PreparedStatement ps) {
                JdbcUtils.closeQuietly((Statement)ps);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(Connection connection, PreparedStatementCreator statementCreator, PreparedStatementExecutor<T> statementExecutor) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = statementCreator.createPreparedStatement(connection);
            T t = statementExecutor.execute(ps);
            return t;
        }
        finally {
            statementExecutor.close(ps);
        }
    }

    public static void setUseCachedRowSet(boolean useCachedRowSet) {
        SqlRunner.useCachedRowSet = useCachedRowSet;
    }

    private static class PageableQueryImpl<T>
    extends PageableSlice<T>
    implements PageableQuery<T> {
        private final ConnectionFactory connectionFactory;
        private final PageableSql pageableSql;
        private final PreparedStatementCallback callback;
        private final RowMapper<T> rowMapper;
        private final SqlRunner sqlRunner;

        private PageableQueryImpl(ConnectionFactory connectionFactory, PageableSql pageableSql, PreparedStatementCallback callback, RowMapper<T> rowMapper, SqlRunner sqlRunner) {
            this.connectionFactory = connectionFactory;
            this.pageableSql = pageableSql;
            this.callback = callback;
            this.rowMapper = rowMapper;
            this.sqlRunner = sqlRunner;
        }

        public int rowCount() {
            String sql = this.pageableSql.countableSql();
            Connection connection = null;
            try {
                connection = this.connectionFactory.getConnection();
                int n = this.sqlRunner.queryForObject(connection, sql, this.callback, Integer.class);
                return n;
            }
            catch (SQLException e) {
                throw new PageableException(e.getMessage(), (Throwable)e);
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        public Cursor<T> cursor(int maxResults, int firstResult) {
            String sql = this.pageableSql.pageableSql(maxResults, firstResult);
            Connection connection = null;
            try {
                connection = this.connectionFactory.getConnection();
                if (useCachedRowSet) {
                    return this.sqlRunner.queryForCachedCursor(connection, sql, this.callback, this.rowMapper);
                }
                return this.sqlRunner.queryForCursor(connection, sql, this.callback, this.rowMapper);
            }
            catch (SQLException e) {
                throw new PageableException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

