/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.db4j;

import com.github.paganini2008.devtools.collection.Tuple;
import com.github.paganini2008.devtools.db4j.Customizable;
import com.github.paganini2008.devtools.db4j.GeneratedKey;
import com.github.paganini2008.devtools.db4j.ParsedSqlRunner;
import com.github.paganini2008.devtools.db4j.ResultSetExtractor;
import com.github.paganini2008.devtools.db4j.SqlParameter;
import com.github.paganini2008.devtools.db4j.SqlParameters;
import com.github.paganini2008.devtools.db4j.Transaction;
import com.github.paganini2008.devtools.db4j.TransactionException;
import com.github.paganini2008.devtools.db4j.mapper.RowMapper;
import com.github.paganini2008.devtools.jdbc.Cursor;
import com.github.paganini2008.devtools.jdbc.JdbcUtils;
import com.github.paganini2008.devtools.jdbc.PageableQuery;
import com.github.paganini2008.devtools.jdbc.PageableSql;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class TransactionImpl
implements Transaction {
    private final Connection connection;
    private final ParsedSqlRunner sqlRunner;
    private final AtomicBoolean completed;

    TransactionImpl(Connection connection, ParsedSqlRunner sqlRunner) {
        this.connection = connection;
        this.sqlRunner = sqlRunner;
        this.completed = new AtomicBoolean(false);
    }

    @Override
    public int update(String sql, SqlParameter sqlParameter) throws SQLException {
        return this.sqlRunner.update(this.connection, sql, sqlParameter);
    }

    @Override
    public int update(String sql, SqlParameter sqlParameter, GeneratedKey generatedKey) throws SQLException {
        return this.sqlRunner.update(this.connection, sql, sqlParameter, generatedKey);
    }

    @Override
    public int[] batchUpdate(String sql, SqlParameters sqlParameters) throws SQLException {
        return this.sqlRunner.batchUpdate(this.connection, sql, sqlParameters);
    }

    @Override
    public <T> T query(String sql, SqlParameter sqlParameter, ResultSetExtractor<T> extractor) throws SQLException {
        return this.sqlRunner.query(this.connection, sql, sqlParameter, extractor);
    }

    @Override
    public List<Tuple> queryForList(String sql, SqlParameter sqlParameter) throws SQLException {
        return this.sqlRunner.queryForList(this.connection, sql, sqlParameter);
    }

    @Override
    public <T> T queryForObject(String sql, SqlParameter sqlParameter, RowMapper<T> rowMapper) throws SQLException {
        return this.sqlRunner.queryForObject(this.connection, sql, sqlParameter, rowMapper);
    }

    @Override
    public <T> List<T> queryForList(String sql, SqlParameter sqlParameter, RowMapper<T> rowMapper) throws SQLException {
        return this.sqlRunner.queryForList(this.connection, sql, sqlParameter, rowMapper);
    }

    @Override
    public <T> Cursor<T> queryForCursor(String sql, SqlParameter sqlParameter, RowMapper<T> rowMapper) throws SQLException {
        return this.sqlRunner.queryForCursor(this.connection, sql, sqlParameter, rowMapper);
    }

    @Override
    public <T> Cursor<T> queryForCachedCursor(String sql, SqlParameter sqlParameter, RowMapper<T> rowMapper) throws SQLException {
        return this.sqlRunner.queryForCachedCursor(this.connection, sql, sqlParameter, rowMapper);
    }

    @Override
    public PageableQuery<Tuple> queryForPage(PageableSql pageableSql, SqlParameter sqlParameter) throws SQLException {
        return this.sqlRunner.queryForPage(() -> this.connection, pageableSql, sqlParameter);
    }

    @Override
    public <T> PageableQuery<T> queryForPage(PageableSql pageableSql, SqlParameter sqlParameter, RowMapper<T> rowMapper) throws SQLException {
        return this.sqlRunner.queryForPage(() -> this.connection, pageableSql, sqlParameter, rowMapper);
    }

    @Override
    public <T> T customize(Customizable<T> customizable) throws SQLException {
        return customizable.customize(this.connection, this.sqlRunner);
    }

    @Override
    public void rollback() {
        try {
            JdbcUtils.rollback((Connection)this.connection);
            this.completed.set(true);
        }
        catch (SQLException e) {
            throw new TransactionException(e);
        }
    }

    @Override
    public void commit() {
        try {
            JdbcUtils.commit((Connection)this.connection);
            this.completed.set(true);
        }
        catch (SQLException e) {
            throw new TransactionException(e);
        }
    }

    @Override
    public void close() {
        JdbcUtils.closeQuietly((Connection)this.connection);
    }

    @Override
    public boolean isCompleted() {
        return this.completed.get();
    }
}

