/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.db4j;

import com.github.paganini2008.devtools.db4j.JdbcType;
import com.github.paganini2008.devtools.db4j.TypeHandlerRegistry;
import com.github.paganini2008.devtools.db4j.type.BigDecimalTypeHandler;
import com.github.paganini2008.devtools.db4j.type.BigIntegerTypeHandler;
import com.github.paganini2008.devtools.db4j.type.BlobTypeHandler;
import com.github.paganini2008.devtools.db4j.type.BooleanTypeHandler;
import com.github.paganini2008.devtools.db4j.type.ByteTypeHandler;
import com.github.paganini2008.devtools.db4j.type.BytesTypeHandler;
import com.github.paganini2008.devtools.db4j.type.CharacterTypeHandler;
import com.github.paganini2008.devtools.db4j.type.ClobTypeHandler;
import com.github.paganini2008.devtools.db4j.type.DateTypeHandler;
import com.github.paganini2008.devtools.db4j.type.DoubleTypeHandler;
import com.github.paganini2008.devtools.db4j.type.EnumTypeHandler;
import com.github.paganini2008.devtools.db4j.type.FloatTypeHandler;
import com.github.paganini2008.devtools.db4j.type.IntegerTypeHandler;
import com.github.paganini2008.devtools.db4j.type.LongTypeHandler;
import com.github.paganini2008.devtools.db4j.type.ObjectTypeHandler;
import com.github.paganini2008.devtools.db4j.type.ShortTypeHandler;
import com.github.paganini2008.devtools.db4j.type.SqlDateTypeHandler;
import com.github.paganini2008.devtools.db4j.type.SqlTimeTypeHandler;
import com.github.paganini2008.devtools.db4j.type.StringTypeHandler;
import com.github.paganini2008.devtools.db4j.type.TimestampTypeHandler;
import com.github.paganini2008.devtools.db4j.type.TypeHandler;
import com.github.paganini2008.devtools.db4j.type.UndefinedTypeHandler;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public class TypeHandlerRegistryImpl
implements TypeHandlerRegistry {
    private static final Map<Type, Type> wrapperPrimitiveMap = new HashMap<Type, Type>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(Byte.class, Byte.TYPE);
            this.put(Short.class, Short.TYPE);
            this.put(Integer.class, Integer.TYPE);
            this.put(Long.class, Long.TYPE);
            this.put(Float.class, Float.TYPE);
            this.put(Double.class, Double.TYPE);
            this.put(Boolean.class, Boolean.TYPE);
            this.put(Character.class, Character.TYPE);
        }
    };
    private static final ObjectTypeHandler OBJECT_TYPE_HANDLER = new ObjectTypeHandler();
    private final Map<JdbcType, TypeHandler> jdbcTypeHandlers = new EnumMap<JdbcType, TypeHandler>(JdbcType.class);
    private final Map<Type, Map<JdbcType, TypeHandler>> javaTypeHandlers = new HashMap<Type, Map<JdbcType, TypeHandler>>();

    public static TypeHandler getDefault() {
        return OBJECT_TYPE_HANDLER;
    }

    public TypeHandlerRegistryImpl() {
        TypeHandler typeHandler = new ByteTypeHandler();
        this.register((Type)((Object)Byte.class), typeHandler);
        this.register(JdbcType.TINYINT, typeHandler);
        typeHandler = new ShortTypeHandler();
        this.register((Type)((Object)Short.class), typeHandler);
        this.register(JdbcType.SMALLINT, typeHandler);
        typeHandler = new IntegerTypeHandler();
        this.register((Type)((Object)Integer.class), typeHandler);
        this.register(JdbcType.INTEGER, typeHandler);
        typeHandler = new LongTypeHandler();
        this.register((Type)((Object)Long.class), typeHandler);
        this.register(JdbcType.BIGINT, typeHandler);
        typeHandler = new FloatTypeHandler();
        this.register((Type)((Object)Float.class), typeHandler);
        this.register(JdbcType.FLOAT, typeHandler);
        typeHandler = new DoubleTypeHandler();
        this.register((Type)((Object)Double.class), typeHandler);
        this.register(JdbcType.DOUBLE, typeHandler);
        typeHandler = new CharacterTypeHandler();
        this.register((Type)((Object)Character.class), typeHandler);
        this.register(JdbcType.CHAR, typeHandler);
        typeHandler = new BooleanTypeHandler();
        this.register((Type)((Object)Boolean.class), typeHandler);
        this.register(JdbcType.BOOLEAN, typeHandler);
        this.register(JdbcType.BIT, typeHandler);
        typeHandler = new BigDecimalTypeHandler();
        this.register((Type)((Object)BigDecimal.class), typeHandler);
        this.register(JdbcType.REAL, typeHandler);
        this.register(JdbcType.DECIMAL, typeHandler);
        this.register(JdbcType.NUMERIC, typeHandler);
        this.register((Type)((Object)BigInteger.class), (TypeHandler)new BigIntegerTypeHandler());
        typeHandler = new StringTypeHandler();
        this.register((Type)((Object)String.class), typeHandler);
        this.register((Type)((Object)String.class), JdbcType.CHAR, typeHandler);
        this.register((Type)((Object)String.class), JdbcType.VARCHAR, typeHandler);
        this.register((Type)((Object)String.class), JdbcType.NVARCHAR, typeHandler);
        this.register((Type)((Object)String.class), JdbcType.NCHAR, typeHandler);
        this.register((Type)((Object)String.class), JdbcType.LONGVARCHAR, typeHandler);
        this.register(JdbcType.CHAR, typeHandler);
        this.register(JdbcType.VARCHAR, typeHandler);
        this.register(JdbcType.NVARCHAR, typeHandler);
        this.register(JdbcType.NCHAR, typeHandler);
        this.register(JdbcType.LONGVARCHAR, typeHandler);
        typeHandler = new ClobTypeHandler();
        this.register((Type)((Object)String.class), JdbcType.CLOB, typeHandler);
        this.register((Type)((Object)String.class), JdbcType.NCLOB, typeHandler);
        this.register(JdbcType.CLOB, typeHandler);
        this.register(JdbcType.NCLOB, typeHandler);
        typeHandler = new BlobTypeHandler();
        this.register((Type)((Object)byte[].class), JdbcType.BLOB, typeHandler);
        this.register((Type)((Object)byte[].class), JdbcType.LONGVARBINARY, typeHandler);
        this.register(JdbcType.BLOB, (TypeHandler)new BlobTypeHandler());
        this.register(JdbcType.LONGVARBINARY, (TypeHandler)new BlobTypeHandler());
        this.register((Type)((Object)byte[].class), (TypeHandler)new BytesTypeHandler());
        this.register((Type)((Object)Object.class), (TypeHandler)OBJECT_TYPE_HANDLER);
        this.register(JdbcType.OBJECT, (TypeHandler)OBJECT_TYPE_HANDLER);
        this.register((Type)null, (TypeHandler)OBJECT_TYPE_HANDLER);
        this.register(JdbcType.NULL, (TypeHandler)OBJECT_TYPE_HANDLER);
        typeHandler = new UndefinedTypeHandler(this);
        this.register((Type)((Object)Object.class), JdbcType.OTHER, typeHandler);
        this.register(JdbcType.OTHER, typeHandler);
        typeHandler = new DateTypeHandler();
        this.register((Type)((Object)java.util.Date.class), typeHandler);
        this.register((Type)((Object)java.util.Date.class), JdbcType.TIMESTAMP, typeHandler);
        typeHandler = new SqlDateTypeHandler();
        this.register((Type)((Object)java.util.Date.class), JdbcType.DATE, typeHandler);
        this.register(JdbcType.DATE, typeHandler);
        this.register((Type)((Object)Date.class), typeHandler);
        typeHandler = new SqlTimeTypeHandler();
        this.register((Type)((Object)java.util.Date.class), JdbcType.TIME, typeHandler);
        this.register(JdbcType.TIME, typeHandler);
        this.register((Type)((Object)Time.class), typeHandler);
        typeHandler = new TimestampTypeHandler();
        this.register((Type)((Object)Timestamp.class), typeHandler);
        this.register(JdbcType.TIMESTAMP, typeHandler);
    }

    @Override
    public TypeHandler getTypeHandler(Type type) {
        return this.getTypeHandler(type, JdbcType.OTHER);
    }

    @Override
    public TypeHandler getTypeHandler(Type javaType, JdbcType jdbcType) {
        TypeHandler find = null;
        Map<JdbcType, TypeHandler> map = this.javaTypeHandlers.get(javaType);
        find = map == null ? this.jdbcTypeHandlers.get((Object)jdbcType) : map.get((Object)jdbcType);
        if (find == null && jdbcType == JdbcType.ENUM && Enum.class.isAssignableFrom((Class)javaType)) {
            return new EnumTypeHandler((Class)javaType);
        }
        if (find == null) {
            find = OBJECT_TYPE_HANDLER;
        }
        return find;
    }

    @Override
    public void register(JdbcType jdbcType, TypeHandler typeHandler) {
        this.jdbcTypeHandlers.put(jdbcType, typeHandler);
    }

    @Override
    public void register(Type javaType, TypeHandler typeHandler) {
        this.register(javaType, JdbcType.OTHER, typeHandler);
    }

    @Override
    public void register(Type javaType, JdbcType jdbcType, TypeHandler typeHandler) {
        Map<JdbcType, TypeHandler> map = this.javaTypeHandlers.get(javaType);
        if (map == null) {
            this.javaTypeHandlers.put(javaType, new HashMap());
            map = this.javaTypeHandlers.get(javaType);
        }
        map.put(jdbcType, typeHandler);
        if (wrapperPrimitiveMap.containsKey(javaType)) {
            this.register(wrapperPrimitiveMap.get(javaType), jdbcType, typeHandler);
        }
    }
}

