/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.db4j.examples;

import com.github.paganini2008.devtools.RandomUtils;
import com.github.paganini2008.devtools.collection.Tuple;
import com.github.paganini2008.devtools.db4j.ParsedSqlRunner;
import com.github.paganini2008.devtools.jdbc.Cursor;
import com.github.paganini2008.devtools.jdbc.JdbcUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;

public class SqlRunnerTester {
    private static Connection getConnection() throws SQLException {
        String jdbcUrl = "jdbc:mysql://localhost:3306/test?userUnicode=true&characterEncoding=UTF8&useSSL=false&serverTimezone=UTC&autoReconnect=true&zeroDateTimeBehavior=convertToNull";
        String user = "fengy";
        String password = "123456";
        return DriverManager.getConnection(jdbcUrl, user, password);
    }

    public static void test1() throws SQLException {
        ParsedSqlRunner sqlRunner = new ParsedSqlRunner();
        Connection connection = SqlRunnerTester.getConnection();
        List<Tuple> list = sqlRunner.queryForList(connection, "select * from ccms_param limit 100", new Object[]{RandomUtils.randomInt((int)1, (int)4)});
        for (Tuple tuple : list) {
            System.out.println(tuple);
        }
        System.out.println("Total rows: " + list.size());
        JdbcUtils.closeQuietly((Connection)connection);
    }

    public static void test2() throws SQLException {
        ParsedSqlRunner sqlRunner = new ParsedSqlRunner();
        Connection connection = SqlRunnerTester.getConnection();
        Cursor<Tuple> cursor = sqlRunner.queryForCursor(connection, "select * from crawler_resources limit 1000");
        while (cursor.hasNext()) {
            Tuple tuple = (Tuple)cursor.next();
            System.out.println(cursor.getRownum() + ": " + tuple.get("title") + "\t" + tuple.get("url"));
        }
        cursor.close();
        JdbcUtils.closeQuietly((Connection)connection);
    }

    public static void test3() throws SQLException {
        ParsedSqlRunner sqlRunner = new ParsedSqlRunner();
        Connection connection = SqlRunnerTester.getConnection();
        Cursor<Tuple> cursor = sqlRunner.queryForCachedCursor(connection, "select * from crawler_resources limit 100");
        while (cursor.hasNext()) {
            Tuple tuple = (Tuple)cursor.next();
            System.out.println(tuple.get("title") + "\t" + tuple.get("url"));
        }
        cursor.close();
        JdbcUtils.closeQuietly((Connection)connection);
    }

    public static void main(String[] args) throws SQLException {
        SqlRunnerTester.test2();
    }
}

