/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.db4j.mapper;

import com.github.paganini2008.devtools.db4j.Db4jUtils;
import com.github.paganini2008.devtools.db4j.JdbcType;
import com.github.paganini2008.devtools.db4j.TypeHandlerRegistry;
import com.github.paganini2008.devtools.db4j.TypeHandlerRegistryImpl;
import com.github.paganini2008.devtools.db4j.mapper.RowMapper;
import com.github.paganini2008.devtools.db4j.type.TypeHandler;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public abstract class AbstractRowMapper<T>
implements RowMapper<T> {
    @Override
    public T mapRow(int rowIndex, ResultSet rs, TypeHandlerRegistry typeHandlerRegistry) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        T object = this.createObject(columnCount);
        for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
            String columnName = this.getColumnName(rsmd, columnIndex);
            String columnDisplayName = this.getColumnDisplayName(rsmd, columnIndex);
            Type javaType = this.getJavaType(rsmd, columnIndex);
            JdbcType jdbcType = this.getJdbcType(rsmd, columnIndex);
            Object columnValue = this.getColumnValue(rs, columnName, columnIndex, javaType, jdbcType, typeHandlerRegistry);
            this.setValue(object, columnIndex, columnName, columnDisplayName, jdbcType, columnValue);
        }
        return object;
    }

    protected abstract T createObject(int var1);

    protected abstract void setValue(T var1, int var2, String var3, String var4, JdbcType var5, Object var6);

    protected Type getJavaType(ResultSetMetaData rsmd, int columnIndex) {
        String className;
        try {
            className = rsmd.getColumnClassName(columnIndex);
        }
        catch (SQLException e) {
            return null;
        }
        return Db4jUtils.getClassNamesAndJavaTypes().get(className);
    }

    protected JdbcType getJdbcType(ResultSetMetaData rsmd, int columnIndex) {
        try {
            return JdbcType.find(rsmd.getColumnType(columnIndex));
        }
        catch (SQLException e) {
            return null;
        }
    }

    protected String getColumnDisplayName(ResultSetMetaData rsmd, int columnIndex) throws SQLException {
        return rsmd.getColumnLabel(columnIndex);
    }

    protected String getColumnName(ResultSetMetaData rsmd, int columnIndex) throws SQLException {
        return rsmd.getColumnName(columnIndex);
    }

    protected Object getColumnValue(ResultSet rs, String columnName, int columnIndex, Type javaType, JdbcType jdbcType, TypeHandlerRegistry typeHandlerRegistry) throws SQLException {
        TypeHandler typeHandler = typeHandlerRegistry != null ? typeHandlerRegistry.getTypeHandler(javaType, jdbcType) : TypeHandlerRegistryImpl.getDefault();
        return typeHandler.getValue(rs, columnIndex);
    }
}

