/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.db4j.type;

import com.github.paganini2008.devtools.db4j.JdbcType;
import com.github.paganini2008.devtools.db4j.type.BasicTypeHandler;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BlobTypeHandler
extends BasicTypeHandler {
    @Override
    protected void setNonNullValue(PreparedStatement ps, int parameterIndex, Object parameter, JdbcType jdbcType) throws SQLException {
        byte[] bytes = this.getJavaType().cast(parameter);
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ps.setBinaryStream(parameterIndex, (InputStream)bis, bytes.length);
    }

    protected byte[] getNullableValue(ResultSet rs, String columnName) throws SQLException {
        Blob blob = rs.getBlob(columnName);
        byte[] returnValue = null;
        if (null != blob) {
            returnValue = blob.getBytes(1L, (int)blob.length());
        }
        return returnValue;
    }

    protected byte[] getNullableValue(ResultSet rs, int columnIndex) throws SQLException {
        Blob blob = rs.getBlob(columnIndex);
        byte[] returnValue = null;
        if (null != blob) {
            returnValue = blob.getBytes(1L, (int)blob.length());
        }
        return returnValue;
    }

    public Class<byte[]> getJavaType() {
        return byte[].class;
    }

    @Override
    public Object getNullableValue(CallableStatement cs, int columnIndex) throws SQLException {
        Blob blob = cs.getBlob(columnIndex);
        byte[] returnValue = null;
        if (null != blob) {
            returnValue = blob.getBytes(1L, (int)blob.length());
        }
        return returnValue;
    }
}

