/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.db4j.type;

import com.github.paganini2008.devtools.db4j.JdbcType;
import com.github.paganini2008.devtools.db4j.type.BasicTypeHandler;
import java.io.Reader;
import java.io.StringReader;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ClobTypeHandler
extends BasicTypeHandler {
    @Override
    protected void setNonNullValue(PreparedStatement ps, int parameterIndex, Object parameter, JdbcType jdbcType) throws SQLException {
        String content = this.getJavaType().cast(parameter);
        StringReader reader = new StringReader(content);
        ps.setCharacterStream(parameterIndex, (Reader)reader, content.length());
    }

    @Override
    protected String getNullableValue(ResultSet rs, String columnName) throws SQLException {
        Clob clob = rs.getClob(columnName);
        if (clob != null) {
            int size = (int)clob.length();
            return clob.getSubString(1L, size);
        }
        return null;
    }

    @Override
    protected String getNullableValue(ResultSet rs, int columnIndex) throws SQLException {
        Clob clob = rs.getClob(columnIndex);
        if (clob != null) {
            int size = (int)clob.length();
            return clob.getSubString(1L, size);
        }
        return null;
    }

    @Override
    public Object getNullableValue(CallableStatement cs, int columnIndex) throws SQLException {
        Clob clob = cs.getClob(columnIndex);
        if (clob != null) {
            int size = (int)clob.length();
            return clob.getSubString(1L, size);
        }
        return null;
    }

    public Class<String> getJavaType() {
        return String.class;
    }
}

