/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.db4j.type;

import com.github.paganini2008.devtools.db4j.JdbcType;
import com.github.paganini2008.devtools.db4j.TypeHandlerRegistry;
import com.github.paganini2008.devtools.db4j.TypeHandlerRegistryImpl;
import com.github.paganini2008.devtools.db4j.type.ObjectTypeHandler;
import com.github.paganini2008.devtools.db4j.type.TypeHandler;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class UndefinedTypeHandler
implements TypeHandler {
    private final TypeHandlerRegistry typeHandlerRegistry;

    public UndefinedTypeHandler(TypeHandlerRegistry typeHandlerRegistry) {
        this.typeHandlerRegistry = typeHandlerRegistry;
    }

    @Override
    public void setValue(PreparedStatement ps, int parameterIndex, Object parameter, JdbcType jdbcType) throws SQLException {
        TypeHandler typeHandler = this.typeHandlerRegistry.getTypeHandler(parameter != null ? parameter.getClass() : null, jdbcType);
        try {
            typeHandler.setValue(ps, parameterIndex, parameter, jdbcType);
        }
        catch (SQLException e) {
            if (!(typeHandler instanceof ObjectTypeHandler)) {
                TypeHandlerRegistryImpl.getDefault().setValue(ps, parameterIndex, parameter, jdbcType);
            }
            throw e;
        }
    }

    @Override
    public Object getValue(ResultSet rs, String columnName) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            String columnLabel = rsmd.getColumnLabel(i);
            if (!columnLabel.equals(columnName)) continue;
            return this.getValue(rs, i);
        }
        throw new IllegalStateException("Unknown column: " + columnName);
    }

    @Override
    public Object getValue(ResultSet rs, int columnIndex) throws SQLException {
        TypeHandler typeHandler = this.typeHandlerRegistry.getTypeHandler(null, JdbcType.find(rs.getMetaData().getColumnType(columnIndex)));
        try {
            return typeHandler.getValue(rs, columnIndex);
        }
        catch (SQLException e) {
            if (!(typeHandler instanceof ObjectTypeHandler)) {
                return TypeHandlerRegistryImpl.getDefault().getValue(rs, columnIndex);
            }
            throw e;
        }
    }

    @Override
    public Object getValue(CallableStatement cs, int columnIndex) throws SQLException {
        TypeHandler typeHandler = this.typeHandlerRegistry.getTypeHandler(null, JdbcType.find(cs.getMetaData().getColumnType(columnIndex)));
        try {
            return typeHandler.getValue(cs, columnIndex);
        }
        catch (SQLException e) {
            if (!(typeHandler instanceof ObjectTypeHandler)) {
                return TypeHandlerRegistryImpl.getDefault().getValue(cs, columnIndex);
            }
            throw e;
        }
    }
}

