/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools;

import com.github.paganini2008.devtools.ArrayUtils;
import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.collection.LruMap;
import java.util.Locale;

public abstract class LocaleUtils {
    private static final LruMap<String, Locale> localeCache = new LruMap(16);

    public static Locale getLocale(String str) {
        if (StringUtils.isBlank(str)) {
            throw new IllegalArgumentException("Locale format is required.");
        }
        Locale locale = localeCache.get(str);
        if (null == locale) {
            locale = LocaleUtils.toLocale(str);
            localeCache.put(str, locale);
        }
        return locale;
    }

    public static Locale toLocale(String str) {
        if (StringUtils.isBlank(str)) {
            throw new IllegalArgumentException("Locale format is required.");
        }
        String[] args = str.split("_");
        int length = args.length;
        if (length > 3) {
            throw new IllegalArgumentException("Invalid locale format: " + str);
        }
        switch (length) {
            case 2: 
            case 3: {
                if (args[1].length() != 2 && !args[1].matches("[A-Z]+")) {
                    throw new IllegalArgumentException("Invalid locale format: " + str);
                }
            }
            case 1: {
                if (args[0].length() == 2 || args[0].matches("[a-z]+")) break;
                throw new IllegalArgumentException("Invalid locale format: " + str);
            }
        }
        args = ArrayUtils.copy(args, 0, 3, "");
        return new Locale(args[0], args[1], args[2]);
    }
}

