/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools;

import com.github.paganini2008.devtools.ArrayUtils;
import com.github.paganini2008.devtools.collection.CollectionUtils;
import com.github.paganini2008.devtools.collection.MapUtils;
import com.github.paganini2008.devtools.primitives.Booleans;
import com.github.paganini2008.devtools.primitives.Bytes;
import com.github.paganini2008.devtools.primitives.Chars;
import com.github.paganini2008.devtools.primitives.Doubles;
import com.github.paganini2008.devtools.primitives.Floats;
import com.github.paganini2008.devtools.primitives.Ints;
import com.github.paganini2008.devtools.primitives.Longs;
import com.github.paganini2008.devtools.primitives.Shorts;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;

public abstract class ObjectUtils {
    public static String toString(Object other) {
        return other != null ? other.toString().trim() : "";
    }

    public static int hashCode(Object other) {
        return other != null ? other.hashCode() : 0;
    }

    public static boolean notEquals(Object left, Object right) {
        return !ObjectUtils.equals(left, right);
    }

    public static boolean equals(Object left, Object right) {
        return left == null ? right == null : left.equals(right);
    }

    public static boolean isArray(Object obj) {
        return obj != null ? obj.getClass().isArray() : false;
    }

    public static boolean isNotArray(Object obj) {
        return !ObjectUtils.isArray(obj);
    }

    public static boolean isInstance(Object arg, Class<?> c) {
        return arg != null ? c.isInstance(arg) : false;
    }

    public static boolean isNotInstance(Object arg, Class<?> c) {
        return !ObjectUtils.isInstance(arg, c);
    }

    public static boolean isNotSameType(Object left, Object right) {
        return !ObjectUtils.isSameType(left, right);
    }

    public static boolean isSameType(Object left, Object right) {
        if (left != null && right != null) {
            return right.getClass() == left.getClass();
        }
        return left == right;
    }

    public static String deepToString(Object obj) {
        if (obj == null) {
            return "";
        }
        String str = obj instanceof Object[] ? ArrayUtils.toString((Object[])obj) : (obj instanceof byte[] ? Bytes.toString((byte[])obj) : (obj instanceof char[] ? Chars.toString((char[])obj) : (obj instanceof short[] ? Shorts.toString((short[])obj) : (obj instanceof int[] ? Ints.toString((int[])obj) : (obj instanceof long[] ? Longs.toString((long[])obj) : (obj instanceof float[] ? Floats.toString((float[])obj) : (obj instanceof double[] ? Doubles.toString((double[])obj) : (CollectionUtils.isCollection(obj) ? CollectionUtils.toString((Collection)obj) : (MapUtils.isMap(obj) ? MapUtils.toString((Map)obj) : (CollectionUtils.isIterator(obj) ? CollectionUtils.toString((Iterator)obj) : (CollectionUtils.isEnumeration(obj) ? CollectionUtils.toString((Enumeration)obj) : obj.toString())))))))))));
        return str;
    }

    public static boolean deepEquals(Object left, Object right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return right == null;
        }
        if (right == null) {
            return false;
        }
        if (left instanceof Object[] && right instanceof Object[]) {
            return ArrayUtils.deepEquals((Object[])left, (Object[])right);
        }
        if (left instanceof boolean[] && right instanceof boolean[]) {
            return Booleans.deepEquals((boolean[])left, (boolean[])right);
        }
        if (left instanceof byte[] && right instanceof byte[]) {
            return Bytes.deepEquals((byte[])left, (byte[])right);
        }
        if (left instanceof char[] && right instanceof char[]) {
            return Chars.deepEquals((char[])left, (char[])right);
        }
        if (left instanceof short[] && right instanceof short[]) {
            return Shorts.deepEquals((short[])left, (short[])right);
        }
        if (left instanceof int[] && right instanceof int[]) {
            return Ints.deepEquals((int[])left, (int[])right);
        }
        if (left instanceof long[] && right instanceof long[]) {
            return Longs.deepEquals((long[])left, (long[])right);
        }
        if (left instanceof float[] && right instanceof float[]) {
            return Floats.deepEquals((float[])left, (float[])right);
        }
        if (left instanceof double[] && right instanceof double[]) {
            return Doubles.deepEquals((double[])left, (double[])right);
        }
        if (left instanceof Collection && right instanceof Collection) {
            return CollectionUtils.deepEquals((Collection)left, (Collection)right);
        }
        if (left instanceof Map && right instanceof Map) {
            return MapUtils.deepEquals((Map)left, (Map)right);
        }
        if (left instanceof Iterator && right instanceof Iterator) {
            return CollectionUtils.deepEquals((Iterator)left, (Iterator)right);
        }
        if (left instanceof Enumeration && right instanceof Enumeration) {
            return CollectionUtils.deepEquals((Enumeration)left, (Enumeration)right);
        }
        return left.equals(right);
    }

    public static int deepHashCode(Object result) {
        if (result == null) {
            return 0;
        }
        int hash = result instanceof Byte ? Bytes.hashCode((Byte)result) : (result instanceof Character ? Chars.hashCode(((Character)result).charValue()) : (result instanceof Short ? Shorts.hashCode((Short)result) : (result instanceof Integer ? Ints.hashCode((Integer)result) : (result instanceof Float ? Floats.hashCode(((Float)result).floatValue()) : (result instanceof Double ? Doubles.hashCode((Double)result) : (result instanceof Long ? Longs.hashCode((Long)result) : (result instanceof Boolean ? Booleans.hashCode((Boolean)result) : (result instanceof Object[] ? ArrayUtils.deepHashCode((Object[])result) : (result instanceof boolean[] ? Booleans.deepHashCode((boolean[])result) : (result instanceof byte[] ? Bytes.deepHashCode((byte[])result) : (result instanceof char[] ? Chars.deepHashCode((char[])result) : (result instanceof short[] ? Shorts.deepHashCode((short[])result) : (result instanceof int[] ? Ints.deepHashCode((int[])result) : (result instanceof long[] ? Longs.deepHashCode((long[])result) : (result instanceof float[] ? Floats.deepHashCode((float[])result) : (result instanceof double[] ? Doubles.deepHashCode((double[])result) : (result instanceof Iterable ? CollectionUtils.deepHashCode((Iterable)result) : (result instanceof Map ? MapUtils.deepHashCode((Map)result) : (result instanceof Iterator ? CollectionUtils.deepHashCode((Iterator)result) : (result instanceof Enumeration ? CollectionUtils.deepHashCode((Enumeration)result) : result.hashCode()))))))))))))))))))));
        return hash;
    }
}

