/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.Observer;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.PriorityBlockingQueue;

public class Observable {
    private static final String DEFAULT_TOPIC = "default";
    private final ConcurrentMap<String, Observers> groups = new ConcurrentHashMap<String, Observers>();
    private final boolean repeated;

    protected Observable(boolean repeated) {
        this.repeated = repeated;
    }

    public void addObserver(Observer ob) {
        this.addObserver(DEFAULT_TOPIC, ob);
    }

    public void addObserver(String topic, Observer ob) {
        Assert.isNull(ob, "Observer must not be null.", new Object[0]);
        Observers obs = (Observers)this.groups.get(topic);
        if (obs == null) {
            this.groups.putIfAbsent(topic, new Observers(this.repeated));
            obs = (Observers)this.groups.get(topic);
        }
        obs.addObserver(ob);
    }

    public void deleteObservers(String topic) {
        Observers obs;
        if (this.groups.containsKey(topic) && (obs = (Observers)this.groups.remove(topic)) != null) {
            obs.clear();
        }
    }

    public void deleteObserver(String topic, Observer ob) {
        Observers obs;
        if (this.groups.containsKey(topic) && (obs = (Observers)this.groups.get(topic)) != null) {
            obs.deleteObserver(ob);
            if (obs.countOfObservers() == 0) {
                this.groups.remove(topic);
            }
        }
    }

    public void notifyObservers() {
        this.notifyObservers(null);
    }

    public void notifyObservers(Object arg) {
        this.notifyObservers(DEFAULT_TOPIC, arg);
    }

    public void notifyObservers(String topic, Object arg) {
        if (this.groups.containsKey(topic)) {
            ((Observers)this.groups.get(topic)).update(this, arg);
        }
    }

    public void clearObservers() {
        for (String topic : this.groups.keySet()) {
            this.deleteObservers(topic);
        }
    }

    public int countOfObservers() {
        int n = 0;
        for (Observers obs : this.groups.values()) {
            n += obs.countOfObservers();
        }
        return n;
    }

    public static Observable repeatable() {
        return new Observable(true);
    }

    public static Observable unrepeatable() {
        return new Observable(false);
    }

    static class Observers
    implements Observer {
        private final Queue<Observer> observers = new PriorityBlockingQueue<Observer>();
        private final boolean repeated;

        Observers(boolean repeated) {
            this.repeated = repeated;
        }

        public void addObserver(Observer observer) {
            if (observer != null && !this.observers.contains(observer)) {
                this.observers.offer(observer);
            }
        }

        public void deleteObserver(Observer observer) {
            if (observer != null) {
                this.observers.remove(observer);
            }
        }

        public int countOfObservers() {
            return this.observers.size();
        }

        public void clear() {
            this.observers.clear();
        }

        @Override
        public void update(Observable ob, Object arg) {
            ArrayDeque<Observer> q = new ArrayDeque<Observer>(this.observers);
            while (!q.isEmpty()) {
                Observer o = (Observer)q.poll();
                o.update(ob, arg);
                if (this.repeated) continue;
                this.observers.remove(o);
            }
        }
    }
}

