/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools;

import com.github.paganini2008.devtools.ShutdownHook;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;

public final class ShutdownHooks {
    private static final HookThread instance = new HookThread();

    public static void addHook(ShutdownHook hook) {
        if (hook != null) {
            ShutdownHooks.instance.queue.add(hook);
        }
    }

    public static void removeHook(ShutdownHook hook) {
        if (hook != null) {
            ShutdownHooks.instance.queue.remove(hook);
        }
    }

    public static void cleanHooks() {
        ShutdownHooks.instance.queue.clear();
    }

    public static int countOfHooks() {
        return ShutdownHooks.instance.queue.size();
    }

    private ShutdownHooks() {
    }

    static {
        Runtime.getRuntime().addShutdownHook(instance);
    }

    static class HookThread
    extends Thread {
        final Queue<ShutdownHook> queue = new PriorityBlockingQueue<ShutdownHook>();

        HookThread() {
        }

        @Override
        public void run() {
            while (!this.queue.isEmpty()) {
                ShutdownHook hook = this.queue.poll();
                try {
                    hook.process();
                    System.out.println("Hook '" + hook.toString() + "'is executed.");
                }
                catch (Throwable e) {
                    hook.ignoreException(e);
                }
            }
        }
    }
}

