/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.PlaceholderTokenParser;
import com.github.paganini2008.devtools.PrefixationTokenParser;
import com.github.paganini2008.devtools.SimpleTokenParser;
import com.github.paganini2008.devtools.SubstrTokenizer;
import com.github.paganini2008.devtools.collection.LruMap;
import com.github.paganini2008.devtools.primitives.Chars;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class StringUtils {
    public static final String lineSeparator = System.getProperty("line.separator");
    public static final String BLANK = " ";
    public static final String EMPTY = "";
    public static final String UNDEFINED = "undefined";
    public static final String BLANK_CHARACTER = " \t\n\r\f";
    public static final String[] EMPTY_ARRAY = new String[0];
    public static final int INDEX_NOT_FOUND = -1;
    private static final LruMap<String, MessageFormat> messageFormatCache = new LruMap(128);

    public static String toLetter(int value) {
        StringBuilder str = new StringBuilder();
        while (value >= 0) {
            str.append((char)(value % 26 + 97));
            value = value / 26 - 1;
        }
        return str.reverse().toString();
    }

    public static String reverse(String str) {
        return StringUtils.isNotBlank(str) ? new StringBuilder(str).reverse().toString() : EMPTY;
    }

    public static String trimLeft(String input) {
        Assert.isNull(input);
        String s = input.trim();
        return input.substring(input.indexOf(s));
    }

    public static String trimRight(String input) {
        Assert.isNull(input);
        String s = input.trim();
        int i = input.indexOf(s);
        return input.substring(0, i + s.length());
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence str) {
        return !StringUtils.isEmpty(str);
    }

    public static boolean isBlank(CharSequence str) {
        if (StringUtils.isEmpty(str)) {
            return true;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence str) {
        return !StringUtils.isBlank(str);
    }

    public static String join(String[] array) {
        return StringUtils.join(array, ",");
    }

    public static String join(String[] array, String delim) {
        return StringUtils.join(array, EMPTY, delim);
    }

    public static String join(String[] array, String preAndSuf, String delim) {
        return StringUtils.join(array, preAndSuf, preAndSuf, delim);
    }

    public static String join(String[] array, String prefix, String suffix, String delim) {
        if (array == null) {
            return EMPTY;
        }
        StringBuilder str = new StringBuilder();
        int l = array.length;
        for (int i = 0; i < l; ++i) {
            str.append(prefix);
            str.append(array[i]);
            str.append(suffix);
            if (i == l - 1) continue;
            str.append(delim);
        }
        return str.toString();
    }

    public static String padding(int length) {
        return StringUtils.repeat(BLANK, length);
    }

    public static String repeat(String str, int length) {
        return StringUtils.repeat(str, null, length);
    }

    public static String repeat(String str, String delim, int length) {
        Assert.isNull(str, "String must not be null.", new Object[0]);
        if (delim == null) {
            delim = EMPTY;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            result.append(str);
            if (i == length - 1) continue;
            result.append(delim);
        }
        return result.toString();
    }

    public static String leftPadding(String str, int length) {
        return StringUtils.leftPadding(str, BLANK, length);
    }

    public static String leftPadding(String str, String place, int length) {
        Assert.isNull(str, "String must not be null.", new Object[0]);
        length = Math.max(str.length(), length);
        int n = length - str.length();
        if (n > 0) {
            return StringUtils.repeat(place, n) + str;
        }
        return str;
    }

    public static String rightPadding(String str, int length) {
        return StringUtils.rightPadding(str, BLANK, length);
    }

    public static String rightPadding(String str, String place, int length) {
        Assert.isNull(str, "String must not be null.", new Object[0]);
        length = Math.max(str.length(), length);
        int n = length - str.length();
        if (n > 0) {
            return str + StringUtils.repeat(place, n);
        }
        return str;
    }

    public static String toUpperCase(String s, int ... indexes) {
        Assert.hasNoText(s);
        StringBuilder result = new StringBuilder(s);
        for (int index : indexes) {
            result.setCharAt(index, Character.toUpperCase(s.charAt(index)));
        }
        return result.toString();
    }

    public static String toLowerCase(String s, int ... indexes) {
        Assert.hasNoText(s);
        StringBuilder result = new StringBuilder(s);
        for (int index : indexes) {
            result.setCharAt(index, Character.toLowerCase(s.charAt(index)));
        }
        return result.toString();
    }

    public static String uncapitalize(String str) {
        return StringUtils.toLowerCase(str, 0);
    }

    public static String capitalize(String str) {
        return StringUtils.toUpperCase(str, 0);
    }

    public static String insert(String str, String substr, int index) {
        Assert.isNull(str, "Source string must not be null.", new Object[0]);
        Assert.isNull(substr, "Substring must not be null.", new Object[0]);
        return new StringBuilder(str).insert(index, substr).toString();
    }

    public static String thumb(CharSequence cs, int length) {
        Assert.hasNoText(cs);
        String s = cs.subSequence(0, Math.min(cs.length(), length)).toString();
        return cs.length() > length ? s + "..." : s;
    }

    public static String substring(String s, int to) {
        return StringUtils.substring(s, 0, to);
    }

    public static String substring(String s, int from, int to) {
        Assert.hasNoText(s);
        return s.substring(from, Math.min(to, s.length()));
    }

    public static List<String> split(CharSequence source, String example) {
        return StringUtils.split(source, example, false);
    }

    public static List<String> split(CharSequence source, String example, boolean returnDelims) {
        return StringUtils.split(source, example, returnDelims, true);
    }

    public static List<String> split(CharSequence source, String example, boolean returnDelims, boolean returnEmpty) {
        Assert.hasNoText(source);
        if (StringUtils.isBlank(example)) {
            example = BLANK_CHARACTER;
        }
        StringTokenizer tokenizer = new StringTokenizer(source.toString(), example, returnDelims);
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            if (!returnEmpty && !StringUtils.isNotBlank(s)) continue;
            list.add(s);
        }
        return list;
    }

    public static List<String> split(CharSequence source, String[] delimiters) {
        return StringUtils.split(source, delimiters, false);
    }

    public static List<String> split(CharSequence source, String[] delimiters, boolean returnDelim) {
        return StringUtils.split(source, delimiters, returnDelim, true);
    }

    public static List<String> split(CharSequence source, String[] delimiters, boolean returnDelims, boolean returnEmpty) {
        Assert.hasNoText(source);
        Assert.isNull(delimiters, "Delimeters must not be null.", new Object[0]);
        SubstrTokenizer tokenizer = new SubstrTokenizer(source, delimiters, returnDelims);
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreElements()) {
            String s = tokenizer.nextElement();
            if (!returnEmpty && !StringUtils.isNotBlank(s)) continue;
            list.add(s);
        }
        return list;
    }

    public static Map<String, String> splitAsMap(CharSequence source, String example) {
        Assert.hasNoText(source);
        if (StringUtils.isBlank(example)) {
            example = BLANK_CHARACTER;
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(source.toString(), example, false);
        String t = null;
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            if (t == null) {
                t = s;
                continue;
            }
            result.put(t, s);
            t = null;
        }
        if (t != null) {
            result.put(t, null);
        }
        return result;
    }

    public static Map<String, String> splitAsMap(CharSequence source, String example, String delimiter) {
        Assert.hasNoText(source);
        Assert.hasNoText(delimiter);
        if (StringUtils.isBlank(example)) {
            example = BLANK_CHARACTER;
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(source.toString(), example, false);
        int n = delimiter.length();
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            if (!StringUtils.isNotBlank(s)) continue;
            int i = s.indexOf(delimiter);
            if (i > 0) {
                result.put(s.substring(0, i), s.substring(i + n));
                continue;
            }
            result.put(s, null);
        }
        return result;
    }

    public static Map<String, String> splitAsMap(CharSequence source, String[] delimiters) {
        Assert.hasNoText(source);
        Assert.isNull(delimiters, "Delimeters must not be null.", new Object[0]);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        SubstrTokenizer tokenizer = new SubstrTokenizer(source, delimiters, false);
        String t = null;
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            if (!StringUtils.isNotBlank(s)) continue;
            if (t == null) {
                t = s;
                continue;
            }
            result.put(t, s);
            t = null;
        }
        if (t != null) {
            result.put(t, null);
        }
        return result;
    }

    public static Map<String, String> splitAsMap(CharSequence source, String[] delimiters, String secondDelimiter) {
        Assert.hasNoText(source);
        Assert.isNull(delimiters, "Delimeters must not be null.", new Object[0]);
        Assert.hasNoText(secondDelimiter);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        SubstrTokenizer tokenizer = new SubstrTokenizer(source, delimiters, false);
        int n = secondDelimiter.length();
        while (tokenizer.hasMoreTokens()) {
            int i;
            String s = tokenizer.nextToken();
            if (!StringUtils.isNotBlank(s)) continue;
            if (n > 0 && (i = s.indexOf(secondDelimiter)) > 0) {
                result.put(s.substring(0, i), s.substring(i + n));
                continue;
            }
            result.put(s, null);
        }
        return result;
    }

    public static String toCamelCase(String str) {
        return StringUtils.toCamelCase(str, "_");
    }

    public static String toCamelCase(String str, String join) {
        Assert.hasNoText(str);
        Assert.hasNoText(join);
        StringBuilder result = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(str, join, false);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int len = result.length();
            result.append(token);
            if (len <= 0) continue;
            result.setCharAt(len, Character.toUpperCase(token.charAt(0)));
        }
        return result.toString();
    }

    public static String toSegmentCase(String str) {
        return StringUtils.toSegmentCase(str, "_");
    }

    public static String toSegmentCase(String str, String join) {
        char[] src;
        Assert.hasNoText(str);
        Assert.isNull(join);
        StringBuilder result = new StringBuilder();
        for (char c : src = str.toCharArray()) {
            if (Character.isUpperCase(c)) {
                result.append(join).append(Character.toLowerCase(c));
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static boolean notEquals(String left, String right) {
        return !StringUtils.equals(left, right);
    }

    public static boolean equals(String left, String right) {
        return left == null ? right == null : left.equals(right);
    }

    public static boolean notEqualsStrictly(String left, String right) {
        return !StringUtils.equalsStrictly(left, right);
    }

    public static boolean equalsStrictly(String left, String right) {
        return StringUtils.isBlank(left) ? StringUtils.isBlank(right) : left.equals(right);
    }

    public static boolean notEqualsIgnoreCase(String left, String right) {
        return !StringUtils.equalsIgnoreCase(left, right);
    }

    public static boolean equalsIgnoreCase(String left, String right) {
        return left == null ? right == null : left.equalsIgnoreCase(right);
    }

    public static boolean notEqualsIgnoreCaseStrictly(String left, String right) {
        return !StringUtils.equalsIgnoreCaseStrictly(left, right);
    }

    public static boolean equalsIgnoreCaseStrictly(String left, String right) {
        return StringUtils.isBlank(left) ? StringUtils.isBlank(right) : left.equalsIgnoreCase(right);
    }

    public static boolean hasContent(String left, String right) {
        return StringUtils.isBlank(left) ? StringUtils.isNotBlank(right) : StringUtils.isBlank(right);
    }

    public static void main(String[] args) throws Exception {
        System.out.println(StringUtils.capitalize("lastModfied"));
    }

    public static String parseText(String text, String prefix, String suffix, Object ... args) {
        Assert.hasNoText(text, "Can't parse blank text.", new Object[0]);
        Assert.hasNoText(prefix, "Prefix string is required.", new Object[0]);
        Assert.hasNoText(suffix, "Suffix string is required.", new Object[0]);
        if (args == null || args.length == 0) {
            return text;
        }
        PlaceholderTokenParser placeholderTokenizer = new PlaceholderTokenParser(prefix, suffix);
        return placeholderTokenizer.parse(text, str -> args[Integer.parseInt(str)]);
    }

    public static String parseText(String text, String prefix, String suffix, Map<String, ?> params) {
        Assert.hasNoText(text, "Can't parse blank text.", new Object[0]);
        Assert.hasNoText(prefix, "Prefix string is required.", new Object[0]);
        Assert.hasNoText(suffix, "Suffix string is required.", new Object[0]);
        if (params == null || params.size() == 0) {
            return text;
        }
        PlaceholderTokenParser placeholderTokenizer = new PlaceholderTokenParser(prefix, suffix);
        return placeholderTokenizer.parse(text, key -> params.get(key));
    }

    public static String parseText(String text, String token, Map<String, ?> params) {
        Assert.hasNoText(text, "Can't parse blank text.", new Object[0]);
        Assert.hasNoText(token, "Token string is required.", new Object[0]);
        if (params == null || params.size() == 0) {
            return text;
        }
        PrefixationTokenParser prefixationTokenizer = new PrefixationTokenParser(token);
        return prefixationTokenizer.parse(text, key -> params.get(key));
    }

    public static String parseText(String text, String token, Object ... args) {
        Assert.hasNoText(text, "Can't parse blank text.", new Object[0]);
        Assert.hasNoText(token, "Token string is required.", new Object[0]);
        if (args == null || args.length == 0) {
            return text;
        }
        PrefixationTokenParser prefixationTokenizer = new PrefixationTokenParser(token);
        return prefixationTokenizer.parse(text, str -> args[Integer.parseInt(str)]);
    }

    public static String format(String text, String token, Object ... args) {
        Assert.hasNoText(text, "Can't parse blank text.", new Object[0]);
        Assert.hasNoText(token, "Token string is required.", new Object[0]);
        if (args == null || args.length == 0) {
            return text;
        }
        SimpleTokenParser simpleTokenizer = new SimpleTokenParser(token);
        return simpleTokenizer.parse(text, index -> args[Integer.min(index, args.length - 1)]);
    }

    public static String unicodeEscape(String unicodeString) {
        Assert.hasNoText(unicodeString);
        StringBuilder content = new StringBuilder();
        for (String str : StringUtils.split((CharSequence)unicodeString, "\\u")) {
            content.append((char)Integer.parseInt(str, 16));
        }
        return content.toString();
    }

    public static String unicodeString(String str) {
        StringBuilder content = new StringBuilder();
        for (char c : str.toCharArray()) {
            content.append(Chars.toUnicode(c));
        }
        return content.toString();
    }

    public static boolean isAlpha(CharSequence str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        int l = str.length();
        for (int i = 0; i < l; ++i) {
            if (Character.isLetter(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(CharSequence str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        int l = str.length();
        for (int i = 0; i < l; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int count(String str, String substr) {
        int count = 0;
        int idx = 0;
        while (-1 != (idx = str.indexOf(substr, idx))) {
            ++count;
            idx += substr.length();
        }
        return count;
    }

    public static int count(String str, char c) {
        int count = 0;
        int idx = 0;
        while (-1 != (idx = str.indexOf(c, idx))) {
            ++count;
            ++idx;
        }
        return count;
    }

    public static String replaceFirst(String template, String placeholder, String replacement) {
        Assert.hasNoText(template);
        Assert.hasNoText(placeholder);
        Assert.hasNoText(replacement);
        int loc = template.indexOf(placeholder);
        if (loc < 0) {
            return template;
        }
        return template.substring(0, loc).concat(replacement).concat(template.substring(loc + placeholder.length()));
    }

    public static MessageFormat getMessageFormat(String pattern) {
        MessageFormat mf = messageFormatCache.get(pattern);
        if (mf == null) {
            messageFormatCache.put(pattern, new MessageFormat(pattern, Locale.ENGLISH));
            mf = messageFormatCache.get(pattern);
        }
        return mf;
    }
}

