/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.cache;

import com.github.paganini2008.devtools.cache.Cache;
import com.github.paganini2008.devtools.cache.HashCache;
import com.github.paganini2008.devtools.cache.LimitedCache;
import com.github.paganini2008.devtools.cache.Store;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;

public class FifoCache
extends LimitedCache {
    private final Cache delegate;
    private final Queue<Object> keys;
    private final int maxSize;
    private Store store;

    public FifoCache(int maxSize) {
        this(new HashCache(), maxSize);
    }

    public FifoCache(Cache delegate, int maxSize) {
        this.delegate = delegate;
        this.maxSize = maxSize;
        this.keys = new ConcurrentLinkedQueue<Object>();
    }

    @Override
    public void setStore(Store store) {
        this.store = store;
    }

    @Override
    public int getSize() {
        return this.delegate.getSize() + (this.store != null ? this.store.getSize() : 0);
    }

    @Override
    public void putObject(Object key, Object value) {
        this.delegate.putObject(key, value);
        this.control(key);
    }

    @Override
    public Object getObject(Object key) {
        Object result = this.delegate.getObject(key);
        if (result == null && this.store != null && (result = this.store.readObject(key)) != null) {
            this.store.removeObject(key);
            this.putObject(key, result);
        }
        return result;
    }

    @Override
    public Object removeObject(Object key) {
        this.keys.remove(key);
        Object result = this.delegate.removeObject(key);
        if (result == null && this.store != null) {
            result = this.store.removeObject(key);
        }
        return result;
    }

    @Override
    public void clear() {
        this.delegate.clear();
        this.keys.clear();
    }

    private void control(Object key) {
        this.keys.add(key);
        if (this.keys.size() > this.maxSize) {
            Object oldestKey = this.keys.poll();
            Object oldestValue = this.delegate.removeObject(oldestKey);
            if (this.store != null) {
                this.store.writeObject(oldestKey, oldestValue);
            }
        }
    }

    @Override
    public Set<Object> keys() {
        HashSet<Object> names = new HashSet<Object>();
        names.addAll(this.keys);
        if (this.store != null) {
            names.addAll(this.store.keys());
        }
        return names;
    }

    @Override
    public boolean hasKey(Object key) {
        return this.delegate.hasKey(key);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

