/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.cache;

import com.github.paganini2008.devtools.cache.Cache;
import com.github.paganini2008.devtools.cache.HashCache;
import com.github.paganini2008.devtools.cache.LimitedCache;
import com.github.paganini2008.devtools.cache.Store;
import com.github.paganini2008.devtools.collection.LruList;
import java.util.HashSet;
import java.util.Set;

public class LruCache
extends LimitedCache {
    private final Cache delegate;
    private final LruList<Object> keys;
    private Store store;

    public LruCache(int maxSize) {
        this(new HashCache(), maxSize);
    }

    public LruCache(final Cache delegate, int maxSize) {
        this.delegate = delegate;
        this.keys = new LruList<Object>(maxSize){
            private static final long serialVersionUID = -7375790466218025547L;

            @Override
            public void onEviction(Object oldestKey) {
                Object oldestValue = delegate.removeObject(oldestKey);
                if (LruCache.this.store != null) {
                    LruCache.this.store.writeObject(oldestKey, oldestValue);
                }
            }
        };
    }

    @Override
    public void setStore(Store store) {
        this.store = store;
    }

    @Override
    public void putObject(Object key, Object value) {
        this.keys.add(key);
        this.delegate.putObject(key, value);
    }

    @Override
    public Object getObject(Object key) {
        Object result = this.delegate.getObject(key);
        if (result == null) {
            if (this.store != null && (result = this.store.readObject(key)) != null && this.store.removeObject(key) != null) {
                this.putObject(key, result);
            }
        } else {
            this.keys.contains(key);
        }
        return result;
    }

    @Override
    public Object removeObject(Object key) {
        this.keys.remove(key);
        Object result = this.delegate.removeObject(key);
        if (result == null && this.store != null) {
            result = this.store.removeObject(key);
        }
        return result;
    }

    @Override
    public int getSize() {
        return this.delegate.getSize() + (this.store != null ? this.store.getSize() : 0);
    }

    @Override
    public Set<Object> keys() {
        HashSet<Object> names = new HashSet<Object>();
        names.addAll(this.keys);
        if (this.store != null) {
            names.addAll(this.store.keys());
        }
        return names;
    }

    @Override
    public void clear() {
        this.keys.clear();
        this.delegate.clear();
    }

    @Override
    public boolean hasKey(Object key) {
        return this.delegate.hasKey(key);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

