/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.cache;

import com.github.paganini2008.devtools.cache.Cache;
import com.github.paganini2008.devtools.cache.HashCache;
import com.github.paganini2008.devtools.cache.LimitedCache;
import com.github.paganini2008.devtools.cache.Store;
import java.util.LinkedHashSet;
import java.util.NavigableSet;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;

public class SortedCache
extends LimitedCache {
    private final Cache delegate;
    private final NavigableSet<Object> keys;
    private final int maxSize;
    private final boolean asc;
    private Store store;

    public SortedCache(int maxSize) {
        this(maxSize, true);
    }

    public SortedCache(int maxSize, boolean asc) {
        this(new HashCache(), maxSize, asc);
    }

    public SortedCache(Cache delegate, int maxSize, boolean asc) {
        this.delegate = delegate;
        this.maxSize = maxSize;
        this.asc = asc;
        this.keys = new ConcurrentSkipListSet<Object>();
    }

    @Override
    public void setStore(Store store) {
        this.store = store;
    }

    @Override
    public void putObject(Object key, Object value) {
        this.delegate.putObject(key, value);
        this.control(key);
    }

    @Override
    public Object getObject(Object key) {
        Object result = this.delegate.getObject(key);
        if (result == null && this.store != null && (result = this.store.readObject(key)) != null) {
            this.store.removeObject(key);
            this.putObject(key, result);
        }
        return result;
    }

    @Override
    public Object removeObject(Object key) {
        this.keys.remove(key);
        Object result = this.delegate.removeObject(key);
        if (result == null && this.store != null) {
            result = this.store.removeObject(key);
        }
        return result;
    }

    @Override
    public int getSize() {
        return this.delegate.getSize() + (this.store != null ? this.store.getSize() : 0);
    }

    @Override
    public void clear() {
        this.keys.clear();
        this.delegate.clear();
    }

    @Override
    public Set<Object> keys() {
        LinkedHashSet<Object> names = new LinkedHashSet<Object>();
        names.addAll(this.keys);
        if (this.store != null) {
            names.addAll(this.store.keys());
        }
        return names;
    }

    @Override
    public boolean hasKey(Object key) {
        return this.delegate.hasKey(key);
    }

    private void control(Object key) {
        this.keys.add(key);
        if (this.keys.size() > this.maxSize) {
            Object oldestKey = this.asc ? this.keys.pollFirst() : this.keys.pollLast();
            Object oldestValue = this.delegate.removeObject(oldestKey);
            if (this.store != null) {
                this.store.writeObject(oldestKey, oldestValue);
            }
        }
    }

    public String toString() {
        return this.delegate.toString();
    }

    public static void main(String[] args) {
        SortedCache cache = new SortedCache(20);
        for (int i = 0; i < 30; ++i) {
            cache.putObject("Key_" + i, i);
        }
        System.out.println(cache);
        System.out.println("LifoCache.main()");
    }
}

