/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.collection;

import com.github.paganini2008.devtools.collection.ListUtils;
import com.github.paganini2008.devtools.jdbc.ResultSetSlice;
import java.util.Collection;
import java.util.List;

public class ListSlice<T>
implements ResultSetSlice<T> {
    private final List<T> list;

    public ListSlice(List<T> list) {
        this.list = list;
    }

    @Override
    public int totalCount() {
        return this.list.size();
    }

    @Override
    public List<T> list(int maxResults, int firstResult) {
        return ListUtils.slice(this.list, maxResults, firstResult);
    }

    public static <T> ListSlice<T> wrap(Collection<T> c) {
        return new ListSlice<T>(ListUtils.toList(c));
    }
}

