/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.collection;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class LruMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = -1958272189245104075L;
    private final Map<K, V> delegate;
    private final Map<K, Object> keys;

    public LruMap() {
        this(128);
    }

    public LruMap(int maxSize) {
        this(new ConcurrentHashMap(), maxSize);
    }

    public LruMap(final Map<K, V> delegate, final int maxSize) {
        this.delegate = delegate;
        this.keys = Collections.synchronizedMap(new LinkedHashMap<K, Object>(16, 0.75f, true){
            private static final long serialVersionUID = -8320557662210764484L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, Object> eldest) {
                boolean result = this.size() > maxSize;
                if (result) {
                    Object eldestValue = delegate.remove(eldest.getKey());
                    LruMap.this.onEviction(eldest.getKey(), eldestValue);
                }
                return result;
            }
        });
    }

    @Override
    public V get(Object key) {
        this.keys.get(key);
        return this.delegate.get(key);
    }

    @Override
    public V put(K key, V value) {
        this.keys.put(key, key);
        return this.delegate.put(key, value);
    }

    @Override
    public V remove(Object key) {
        this.keys.remove(key);
        return this.delegate.remove(key);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public void clear() {
        this.keys.clear();
        this.delegate.clear();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        this.keys.get(key);
        return this.delegate.containsKey(key);
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    protected void onEviction(K key, V eldestValue) {
    }
}

