/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.collection;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class MultiKeyMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 519272736906601965L;
    private final List<K> keys;
    private final Map<Integer, V> values;

    public MultiKeyMap() {
        this(new ArrayList(), new HashMap());
    }

    protected MultiKeyMap(List<K> keys, Map<Integer, V> values) {
        this.keys = keys;
        this.values = values;
    }

    @Override
    public V put(K key, V value) {
        this.keys.add(key);
        return this.values.put(this.keys.lastIndexOf(key), value);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keys.contains(key);
    }

    @Override
    public V get(Object key) {
        int keyIndex = this.keys.indexOf(key);
        return keyIndex != -1 ? (V)this.values.get(keyIndex) : null;
    }

    @Override
    public V remove(Object key) {
        if (this.keys.remove(key)) {
            return this.values.remove(key);
        }
        return null;
    }

    public void removeAll(Object key) {
        while (this.remove(key) != null) {
        }
    }

    @Override
    public void clear() {
        this.keys.clear();
        this.values.clear();
    }

    @Override
    public Set<K> keySet() {
        return new ViewSet<K>(this.keys);
    }

    @Override
    public Collection<V> values() {
        return this.values.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        ArrayList<CombinedEntry<K, V>> list = new ArrayList<CombinedEntry<K, V>>();
        int i = 0;
        Iterator<Map.Entry<Integer, V>> valueIterator = this.values.entrySet().iterator();
        while (i < this.keys.size() && valueIterator.hasNext()) {
            list.add(new CombinedEntry<K, V>(this.keys.get(i++), valueIterator.next()));
        }
        return new ViewSet<Map.Entry<K, V>>(list);
    }

    public static <K, V> Map<K, V> synchronizedMap() {
        return new MultiKeyMap(new CopyOnWriteArrayList(), new ConcurrentHashMap());
    }

    public static void main(String[] args) {
        AbstractMap map = new MultiKeyMap<String, Long>();
        map.put("123", 1L);
        map.put("123", 1L);
        map.put("123", 3L);
        map.put("234", 2L);
        System.out.println(map.keySet());
        System.out.println(map.get("234"));
        map = new IdentityHashMap();
        map.put("123", 1L);
        map.put("123", 1L);
        map.put("123", 3L);
        map.put("234", 2L);
        System.out.println(map);
    }

    static class CombinedEntry<K, V>
    implements Map.Entry<K, V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        final K key;
        final Map.Entry<Integer, V> entry;

        CombinedEntry(K key, Map.Entry<Integer, V> entry) {
            this.key = key;
            this.entry = entry;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.entry.getValue();
        }

        @Override
        public V setValue(V value) {
            return this.entry.setValue(value);
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    static class ViewSet<T>
    extends AbstractSet<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Collection<T> c;

        ViewSet(Collection<T> c) {
            this.c = c;
        }

        @Override
        public Iterator<T> iterator() {
            return this.c.iterator();
        }

        @Override
        public int size() {
            return this.c.size();
        }
    }
}

