/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.converter;

import com.github.paganini2008.devtools.CharsetUtils;
import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.converter.BasicConverter;
import com.github.paganini2008.devtools.converter.Converter;
import com.github.paganini2008.devtools.primitives.Bytes;
import java.nio.charset.Charset;

public class ByteObjectArrayConverter
extends BasicConverter<Byte[]> {
    private final Converter<CharSequence, Byte[]> charSequenceConverter = new Converter<CharSequence, Byte[]>(){

        @Override
        public Byte[] convertValue(CharSequence source, Byte[] defaultValue) {
            if (StringUtils.isBlank(source)) {
                return defaultValue;
            }
            byte[] bytes = source.toString().getBytes(ByteObjectArrayConverter.this.charset);
            return Bytes.toWrappers(bytes);
        }
    };
    private final Converter<char[], Byte[]> charArrayConverter = new Converter<char[], Byte[]>(){

        @Override
        public Byte[] convertValue(char[] source, Byte[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Bytes.toWrappers(source);
        }
    };
    private final Converter<boolean[], Byte[]> booleanArrayConverter = new Converter<boolean[], Byte[]>(){

        @Override
        public Byte[] convertValue(boolean[] source, Byte[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Bytes.toWrappers(source);
        }
    };
    private final Converter<byte[], Byte[]> byteArrayConverter = new Converter<byte[], Byte[]>(){

        @Override
        public Byte[] convertValue(byte[] source, Byte[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Bytes.toWrappers(source);
        }
    };
    private final Converter<Number[], Byte[]> numberArrayConverter = new Converter<Number[], Byte[]>(){

        @Override
        public Byte[] convertValue(Number[] source, Byte[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Bytes.valueOf(source);
        }
    };
    private final Converter<String[], Byte[]> stringArrayConverter = new Converter<String[], Byte[]>(){

        @Override
        public Byte[] convertValue(String[] source, Byte[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Bytes.valueOf(source);
        }
    };
    private Charset charset = CharsetUtils.DEFAULT;

    public ByteObjectArrayConverter() {
        this.registerType(CharSequence.class, this.charSequenceConverter);
        this.registerType(Number[].class, this.numberArrayConverter);
        this.registerType(String[].class, this.stringArrayConverter);
        this.registerType(boolean[].class, this.booleanArrayConverter);
        this.registerType(char[].class, this.charArrayConverter);
        this.registerType(byte[].class, this.byteArrayConverter);
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }
}

