/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.converter;

import com.github.paganini2008.devtools.CharsetUtils;
import com.github.paganini2008.devtools.converter.BasicConverter;
import com.github.paganini2008.devtools.converter.Converter;
import com.github.paganini2008.devtools.io.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;

public class CharArrayConverter
extends BasicConverter<char[]> {
    private final Converter<CharSequence, char[]> charSequenceConverter = new Converter<CharSequence, char[]>(){

        @Override
        public char[] convertValue(CharSequence source, char[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return source.toString().toCharArray();
        }
    };
    private final Converter<InputStream, char[]> inputStreamConverter = new Converter<InputStream, char[]>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public char[] convertValue(InputStream source, char[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            try {
                char[] cArray = IOUtils.toCharArray(source, CharArrayConverter.this.charset);
                return cArray;
            }
            catch (IOException e) {
                char[] cArray = defaultValue;
                return cArray;
            }
            finally {
                IOUtils.closeQuietly(source);
            }
        }
    };
    private final Converter<Reader, char[]> readerConverter = new Converter<Reader, char[]>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public char[] convertValue(Reader source, char[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            try {
                char[] cArray = IOUtils.toCharArray(source);
                return cArray;
            }
            catch (IOException e) {
                char[] cArray = defaultValue;
                return cArray;
            }
            finally {
                IOUtils.closeQuietly(source);
            }
        }
    };
    private Charset charset = CharsetUtils.DEFAULT;

    public CharArrayConverter() {
        this.registerType(CharSequence.class, this.charSequenceConverter);
        this.registerType(InputStream.class, this.inputStreamConverter);
        this.registerType(Reader.class, this.readerConverter);
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }
}

