/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.converter;

import com.github.paganini2008.devtools.converter.BasicConverter;
import com.github.paganini2008.devtools.converter.Converter;
import com.github.paganini2008.devtools.date.LocalDateUtils;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;

public class LocalDateConverter
extends BasicConverter<LocalDate> {
    private final Converter<Long, LocalDate> longConverter = new Converter<Long, LocalDate>(){

        @Override
        public LocalDate convertValue(Long source, LocalDate defaultValue) {
            return LocalDateUtils.toLocalDate(source, LocalDateConverter.this.zoneId, defaultValue);
        }
    };
    private final Converter<String, LocalDate> stringConverter = new Converter<String, LocalDate>(){

        @Override
        public LocalDate convertValue(String source, LocalDate defaultValue) {
            return LocalDateUtils.parseLocalDate(source, LocalDateConverter.this.dateFormatter, defaultValue);
        }
    };
    private final Converter<Date, LocalDate> dateConverter = new Converter<Date, LocalDate>(){

        @Override
        public LocalDate convertValue(Date source, LocalDate defaultValue) {
            return LocalDateUtils.toLocalDate(source, LocalDateConverter.this.zoneId, defaultValue);
        }
    };
    private final Converter<Calendar, LocalDate> calendarConverter = new Converter<Calendar, LocalDate>(){

        @Override
        public LocalDate convertValue(Calendar source, LocalDate defaultValue) {
            return LocalDateUtils.toLocalDate(source, LocalDateConverter.this.zoneId, defaultValue);
        }
    };
    private ZoneId zoneId = ZoneId.systemDefault();
    private DateTimeFormatter dateFormatter = LocalDateUtils.DEFAULT_DATE_FORMATTER;

    public LocalDateConverter() {
        this.registerType(Long.class, this.longConverter);
        this.registerType(String.class, this.stringConverter);
        this.registerType(Date.class, this.dateConverter);
        this.registerType(Calendar.class, this.calendarConverter);
    }

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    public void setDateFormatter(DateTimeFormatter dateFormatter) {
        this.dateFormatter = dateFormatter;
    }
}

