/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.converter;

import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.converter.BasicConverter;
import com.github.paganini2008.devtools.converter.Converter;
import com.github.paganini2008.devtools.primitives.Shorts;
import java.util.List;

public class ShortObjectArrayConverter
extends BasicConverter<Short[]> {
    private final Converter<CharSequence, Short[]> charSequenceConverter = new Converter<CharSequence, Short[]>(){

        @Override
        public Short[] convertValue(CharSequence source, Short[] defaultValue) {
            if (StringUtils.isBlank(source)) {
                return defaultValue;
            }
            List<String> result = StringUtils.split(source, ",");
            return result != null ? Shorts.valueOf(result.toArray(new String[result.size()])) : defaultValue;
        }
    };
    private final Converter<Number[], Short[]> numberArrayConverter = new Converter<Number[], Short[]>(){

        @Override
        public Short[] convertValue(Number[] source, Short[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Shorts.valueOf(source);
        }
    };
    private final Converter<String[], Short[]> stringArrayConverter = new Converter<String[], Short[]>(){

        @Override
        public Short[] convertValue(String[] source, Short[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Shorts.valueOf(source);
        }
    };
    private final Converter<byte[], Short[]> byteArrayConverter = new Converter<byte[], Short[]>(){

        @Override
        public Short[] convertValue(byte[] source, Short[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Shorts.toWrappers(source);
        }
    };
    private final Converter<short[], Short[]> shortArrayConverter = new Converter<short[], Short[]>(){

        @Override
        public Short[] convertValue(short[] source, Short[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Shorts.toWrappers(source);
        }
    };

    public ShortObjectArrayConverter() {
        this.registerType(CharSequence.class, this.charSequenceConverter);
        this.registerType(Number[].class, this.numberArrayConverter);
        this.registerType(String[].class, this.stringArrayConverter);
        this.registerType(byte[].class, this.byteArrayConverter);
        this.registerType(short[].class, this.shortArrayConverter);
    }
}

