/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.converter;

import com.github.paganini2008.devtools.ArrayUtils;
import com.github.paganini2008.devtools.CharsetUtils;
import com.github.paganini2008.devtools.NumberUtils;
import com.github.paganini2008.devtools.collection.CollectionUtils;
import com.github.paganini2008.devtools.collection.MapUtils;
import com.github.paganini2008.devtools.converter.BasicConverter;
import com.github.paganini2008.devtools.converter.Converter;
import com.github.paganini2008.devtools.date.CalendarUtils;
import com.github.paganini2008.devtools.date.DateUtils;
import com.github.paganini2008.devtools.io.IOUtils;
import com.github.paganini2008.devtools.net.UrlUtils;
import com.github.paganini2008.devtools.primitives.Booleans;
import com.github.paganini2008.devtools.primitives.Doubles;
import com.github.paganini2008.devtools.primitives.Floats;
import com.github.paganini2008.devtools.primitives.Ints;
import com.github.paganini2008.devtools.primitives.Longs;
import com.github.paganini2008.devtools.primitives.Shorts;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Clob;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

public class StringConverter
extends BasicConverter<String> {
    private final Converter<UUID, String> uuidConverter = new Converter<UUID, String>(){

        @Override
        public String convertValue(UUID source, String defaultValue) {
            return source != null ? source.toString() : defaultValue;
        }
    };
    private final Converter<Boolean, String> booleanConverter = new Converter<Boolean, String>(){

        @Override
        public String convertValue(Boolean source, String defaultValue) {
            return Booleans.toString(source, defaultValue);
        }
    };
    private final Converter<Character, String> characterConverter = new Converter<Character, String>(){

        @Override
        public String convertValue(Character source, String defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return source.toString();
        }
    };
    private final Converter<Number, String> numberConverter = new Converter<Number, String>(){

        @Override
        public String convertValue(Number source, String defaultValue) {
            return NumberUtils.format(source, StringConverter.this.decimalFormat, defaultValue);
        }
    };
    private final Converter<Date, String> dateConverter = new Converter<Date, String>(){

        @Override
        public String convertValue(Date source, String defaultValue) {
            return DateUtils.format(source, StringConverter.this.dateFormat, defaultValue);
        }
    };
    private final Converter<Calendar, String> calendarConverter = new Converter<Calendar, String>(){

        @Override
        public String convertValue(Calendar source, String defaultValue) {
            return CalendarUtils.format(source, StringConverter.this.dateFormat, defaultValue);
        }
    };
    private final Converter<URL, String> urlConverter = new Converter<URL, String>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String convertValue(URL source, String defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            InputStream in = null;
            try {
                in = UrlUtils.openStream(source);
                String string = IOUtils.toString(in, StringConverter.this.charset);
                return string;
            }
            catch (IOException e) {
                String string = defaultValue;
                return string;
            }
            finally {
                IOUtils.closeQuietly(in);
            }
        }
    };
    private final Converter<Clob, String> clobConverter = new Converter<Clob, String>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String convertValue(Clob source, String defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            Reader reader = null;
            try {
                reader = source.getCharacterStream();
                String string = IOUtils.toString(reader);
                return string;
            }
            catch (Exception e) {
                String string = defaultValue;
                return string;
            }
            finally {
                IOUtils.closeQuietly(reader);
            }
        }
    };
    private final Converter<InputStream, String> inputStreamConverter = new Converter<InputStream, String>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String convertValue(InputStream source, String defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            try {
                String string = IOUtils.toString(source, StringConverter.this.charset);
                return string;
            }
            catch (IOException e) {
                String string = defaultValue;
                return string;
            }
            finally {
                IOUtils.closeQuietly(source);
            }
        }
    };
    private final Converter<Reader, String> readerConverter = new Converter<Reader, String>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String convertValue(Reader source, String defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            try {
                String string = IOUtils.toString(source);
                return string;
            }
            catch (IOException e) {
                String string = defaultValue;
                return string;
            }
            finally {
                IOUtils.closeQuietly(source);
            }
        }
    };
    private final Converter<CharSequence, String> charSequenceConverter = new Converter<CharSequence, String>(){

        @Override
        public String convertValue(CharSequence source, String defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return source.toString();
        }
    };
    private final Converter<byte[], String> byteArrayConverter = new Converter<byte[], String>(){

        @Override
        public String convertValue(byte[] source, String defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return new String(source, StringConverter.this.charset);
        }
    };
    private final Converter<char[], String> charArrayConverter = new Converter<char[], String>(){

        @Override
        public String convertValue(char[] source, String defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return new String(source);
        }
    };
    private final Converter<short[], String> shortArrayConverter = new Converter<short[], String>(){

        @Override
        public String convertValue(short[] source, String defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Shorts.join(source, StringConverter.this.delimiter);
        }
    };
    private final Converter<int[], String> intArrayConverter = new Converter<int[], String>(){

        @Override
        public String convertValue(int[] source, String defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Ints.join(source, StringConverter.this.delimiter);
        }
    };
    private final Converter<long[], String> longArrayConverter = new Converter<long[], String>(){

        @Override
        public String convertValue(long[] source, String defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Longs.join(source, StringConverter.this.delimiter);
        }
    };
    private final Converter<float[], String> floatArrayConverter = new Converter<float[], String>(){

        @Override
        public String convertValue(float[] source, String defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Floats.join(source, StringConverter.this.delimiter);
        }
    };
    private final Converter<double[], String> doubleArrayConverter = new Converter<double[], String>(){

        @Override
        public String convertValue(double[] source, String defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Doubles.join(source, StringConverter.this.delimiter);
        }
    };
    private final Converter<boolean[], String> booleanArrayConverter = new Converter<boolean[], String>(){

        @Override
        public String convertValue(boolean[] source, String defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Booleans.join(source, StringConverter.this.delimiter);
        }
    };
    private final Converter<Object[], String> objectArrayConverter = new Converter<Object[], String>(){

        @Override
        public String convertValue(Object[] source, String defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return ArrayUtils.join(source, StringConverter.this.delimiter);
        }
    };
    private final Converter<Collection<?>, String> collectionConverter = new Converter<Collection<?>, String>(){

        @Override
        public String convertValue(Collection<?> source, String defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return CollectionUtils.join(source, StringConverter.this.delimiter);
        }
    };
    private final Converter<Iterator<?>, String> iteratorConverter = new Converter<Iterator<?>, String>(){

        @Override
        public String convertValue(Iterator<?> source, String defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return CollectionUtils.join(source, StringConverter.this.delimiter);
        }
    };
    private final Converter<Enumeration<?>, String> enumerationConverter = new Converter<Enumeration<?>, String>(){

        @Override
        public String convertValue(Enumeration<?> source, String defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return CollectionUtils.join(source, StringConverter.this.delimiter);
        }
    };
    private final Converter<Map, String> mapConverter = new Converter<Map, String>(){

        @Override
        public String convertValue(Map source, String defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return MapUtils.join(source, StringConverter.this.delimiter);
        }
    };
    private final Converter<Charset, String> charsetConverter = new Converter<Charset, String>(){

        @Override
        public String convertValue(Charset source, String defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return source.name();
        }
    };
    private final Converter<Locale, String> localeConverter = new Converter<Locale, String>(){

        @Override
        public String convertValue(Locale source, String defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return source.toString();
        }
    };
    private String delimiter = ",";
    private Charset charset = CharsetUtils.DEFAULT;
    private DecimalFormat decimalFormat = new DecimalFormat("0.##");
    private DateFormat dateFormat = DateUtils.DEFAULT_DATE_FORMATTER;

    public StringConverter() {
        this.registerType(Boolean.class, this.booleanConverter);
        this.registerType(Character.class, this.characterConverter);
        this.registerType(Number.class, this.numberConverter);
        this.registerType(CharSequence.class, this.charSequenceConverter);
        this.registerType(Date.class, this.dateConverter);
        this.registerType(Calendar.class, this.calendarConverter);
        this.registerType(boolean[].class, this.booleanArrayConverter);
        this.registerType(char[].class, this.charArrayConverter);
        this.registerType(byte[].class, this.byteArrayConverter);
        this.registerType(short[].class, this.shortArrayConverter);
        this.registerType(int[].class, this.intArrayConverter);
        this.registerType(float[].class, this.floatArrayConverter);
        this.registerType(double[].class, this.doubleArrayConverter);
        this.registerType(long[].class, this.longArrayConverter);
        this.registerType(Object[].class, this.objectArrayConverter);
        this.registerType(Collection.class, this.collectionConverter);
        this.registerType(Iterator.class, this.iteratorConverter);
        this.registerType(Enumeration.class, this.enumerationConverter);
        this.registerType(Map.class, this.mapConverter);
        this.registerType(URL.class, this.urlConverter);
        this.registerType(Clob.class, this.clobConverter);
        this.registerType(Reader.class, this.readerConverter);
        this.registerType(InputStream.class, this.inputStreamConverter);
        this.registerType(Charset.class, this.charsetConverter);
        this.registerType(Locale.class, this.localeConverter);
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void setDecimalFormat(DecimalFormat decimalFormat) {
        this.decimalFormat = decimalFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }
}

