/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io;

import com.github.paganini2008.devtools.MatchMode;
import com.github.paganini2008.devtools.collection.ListUtils;
import com.github.paganini2008.devtools.collection.MapUtils;
import com.github.paganini2008.devtools.io.FileUtils;
import com.github.paganini2008.devtools.io.IOUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class BasicProperties
extends Properties {
    private static final long serialVersionUID = 4564916474223591678L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file, String charset) throws IOException {
        BufferedReader reader = null;
        try {
            reader = FileUtils.getBufferedReader(file, charset);
            this.load(reader);
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
    }

    public void load(String name, String charset) throws IOException {
        this.load(name, charset, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String name, String charset, ClassLoader loader) throws IOException {
        Enumeration<URL> urls = loader == null ? ClassLoader.getSystemResources(name) : loader.getResources(name);
        List<URL> urlList = ListUtils.reverse(urls);
        for (URL url : urlList) {
            BufferedReader reader = IOUtils.getBufferedReader(url.openStream(), charset);
            try {
                this.load(reader);
            }
            finally {
                IOUtils.closeQuietly(reader);
            }
        }
    }

    public BasicProperties filter(String prefix) {
        BasicProperties dest = new BasicProperties();
        MapUtils.copyProperties((Properties)this, prefix, dest);
        return dest;
    }

    public BasicProperties filter(String substr, MatchMode mode) {
        BasicProperties dest = new BasicProperties();
        MapUtils.copyProperties((Properties)this, substr, mode, dest);
        return dest;
    }

    public Map<String, String> toMap() {
        return MapUtils.toMap(this);
    }

    public Map<String, String> toMap(String prefix) {
        return MapUtils.toMap(this, prefix);
    }

    public Map<String, String> toMap(String substr, MatchMode mode) {
        return MapUtils.toMap(this, substr, mode);
    }
}

