/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io;

import com.github.paganini2008.devtools.io.FileInfo;
import com.github.paganini2008.devtools.io.Progressable;
import com.github.paganini2008.devtools.multithreads.ExecutorUtils;
import com.github.paganini2008.devtools.multithreads.ThreadPool;
import com.github.paganini2008.devtools.multithreads.ThreadPoolBuilder;
import com.github.paganini2008.devtools.multithreads.ThreadUtils;
import com.github.paganini2008.devtools.multithreads.latch.RecursiveLatch;
import com.github.paganini2008.devtools.primitives.Floats;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class DirectoryWalker {
    private final File directory;
    private final int maxDepth;
    private final FileFilter fileFilter;

    public DirectoryWalker(File directory, int maxDepth, FileFilter fileFilter) {
        this.directory = directory;
        this.maxDepth = maxDepth;
        this.fileFilter = fileFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileInfo walk(int nThreads, Progressable progressable) {
        Executor executor = this.getThreadPool(nThreads);
        try {
            FileInfo fileInfo = this.walk(executor, progressable);
            return fileInfo;
        }
        finally {
            if (executor instanceof ThreadPool) {
                ((ThreadPool)executor).shutdown();
            } else {
                ExecutorUtils.gracefulShutdown(executor, 60000L);
            }
        }
    }

    protected final FileInfo walk(Executor executor, Progressable progressable) {
        FileInfoImpl info = new FileInfoImpl(this.directory);
        ConcurrentHashMap context = new ConcurrentHashMap();
        executor.execute(() -> {
            try {
                this.walk(this.directory, 0, context, executor, info);
            }
            catch (IOException e) {
                this.handleDirectoryIfError(this.directory, 0, e, context);
            }
            finally {
                ThreadUtils.notify(info, () -> info.isFinished());
            }
        });
        if (progressable != null) {
            ThreadUtils.scheduleAtFixedRate(() -> {
                progressable.progress(info.getFileCount(), info.getFolderCount(), info.getLength(), info.getCompletedRatio(), info.getElapsed());
                return !info.isFinished();
            }, 1L, TimeUnit.SECONDS);
        }
        ThreadUtils.wait(info, () -> info.isFinished());
        return info;
    }

    protected Executor getThreadPool(int nThreads) {
        return ThreadPoolBuilder.common(nThreads).setLatch(new RecursiveLatch(nThreads * 2)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void walk(File directory, int depth, Map<String, Object> context, Executor executor, FileInfoImpl info) throws IOException {
        if (this.shouldHandleDirectory(directory, depth, context)) {
            this.enterDirectory(directory, depth, context);
            int childDepth = depth + 1;
            if (this.maxDepth < 0 || childDepth <= this.maxDepth) {
                File[] childFiles;
                File[] fileArray = childFiles = this.fileFilter == null ? directory.listFiles() : directory.listFiles(this.fileFilter);
                if (childFiles != null) {
                    for (File childFile : childFiles) {
                        if (childFile.isDirectory()) {
                            info.folderCount.incrementAndGet();
                            info.startScan(childFile);
                            executor.execute(() -> {
                                try {
                                    this.walk(childFile, childDepth, context, executor, info);
                                }
                                catch (IOException e) {
                                    this.handleDirectoryIfError(childFile, childDepth, e, context);
                                }
                                finally {
                                    info.finishScan(childFile);
                                }
                            });
                            continue;
                        }
                        if (!this.shouldHandleFile(childFile, childDepth, context)) continue;
                        info.fileCount.incrementAndGet();
                        info.length.addAndGet(childFile.length());
                        try {
                            this.handleFile(childFile, childDepth, context);
                        }
                        catch (Exception e) {
                            this.handleFileIfError(childFile, childDepth, e, context);
                        }
                    }
                }
            }
        }
        this.leaveDirectory(directory, depth, context);
    }

    public static void main(String[] args) throws IOException {
        File directory = new File("H:\\JiYong2018");
        DirectoryWalker walker = new DirectoryWalker(directory, -1, null);
        FileInfo fileInfo = walker.walk(10, new Progressable(){

            @Override
            public void progress(int fileCount, int folderCount, long length, float completedRatio, long elapsed) {
                System.out.println("fileCount: " + fileCount + ", folderCount: " + folderCount + ", length: " + length + ", completedRatio: " + completedRatio + ", elapsed: " + elapsed);
            }
        });
        System.out.println(fileInfo.getElapsed());
        System.out.println(fileInfo);
        System.in.read();
        System.out.println("Completed.");
    }

    protected void enterDirectory(File file, int depth, Map<String, Object> context) throws IOException {
    }

    protected void leaveDirectory(File file, int depth, Map<String, Object> context) throws IOException {
    }

    protected void handleDirectoryIfError(File file, int depth, Exception cause, Map<String, Object> context) {
    }

    protected boolean shouldHandleDirectory(File directory, int depth, Map<String, Object> context) throws IOException {
        return true;
    }

    protected boolean shouldHandleFile(File file, int depth, Map<String, Object> context) throws IOException {
        return true;
    }

    protected void handleFile(File file, int depth, Map<String, Object> context) throws IOException {
    }

    protected void handleFileIfError(File file, int depth, Exception cause, Map<String, Object> context) {
    }

    static class FileInfoImpl
    implements FileInfo {
        final AtomicInteger fileCount = new AtomicInteger(0);
        final AtomicInteger folderCount = new AtomicInteger(0);
        final AtomicLong length = new AtomicLong(0L);
        final File directory;
        final long startTime;
        final Map<String, AtomicInteger> files = new ConcurrentHashMap<String, AtomicInteger>();
        final int fileSize;
        long elapsed;

        FileInfoImpl(File directory) {
            this.directory = directory;
            File[] fileArray = directory.listFiles(file -> file.isDirectory());
            if (fileArray != null) {
                for (File file2 : fileArray) {
                    this.files.put(file2.getName(), new AtomicInteger(-1));
                }
            }
            this.fileSize = this.files.size();
            this.startTime = System.currentTimeMillis();
        }

        @Override
        public File getFile() {
            return this.directory;
        }

        @Override
        public long getElapsed() {
            return this.files.size() > 0 ? (this.elapsed = System.currentTimeMillis() - this.startTime) : this.elapsed;
        }

        @Override
        public int getFileCount() {
            return this.fileCount.get();
        }

        @Override
        public int getFolderCount() {
            return this.folderCount.get();
        }

        @Override
        public long getLength() {
            return this.length.get();
        }

        @Override
        public boolean isFinished() {
            return this.files.isEmpty();
        }

        @Override
        public float getCompletedRatio() {
            float value = (float)(this.fileSize - this.files.size()) / (float)this.fileSize;
            return Floats.toFixed(value, 3);
        }

        void startScan(File file) {
            String name = this.getPathName(file);
            AtomicInteger counter = this.files.get(name);
            if (counter != null) {
                counter.incrementAndGet();
            }
        }

        void finishScan(File file) {
            String name = this.getPathName(file);
            AtomicInteger counter = this.files.get(name);
            if (counter != null) {
                if (counter.get() == 0) {
                    this.files.remove(name);
                } else if (counter.get() > 0) {
                    counter.decrementAndGet();
                }
            }
        }

        private String getPathName(File file) {
            String path = file.getAbsolutePath().replace(this.directory.getAbsolutePath(), "");
            int index = path.indexOf(File.separatorChar, 1);
            return index != -1 ? path.substring(1, index) : path.substring(1);
        }
    }
}

