/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io;

import java.io.File;
import java.net.URL;

public class Finder {
    private static final String classPath = Thread.currentThread().getContextClassLoader().getResource("").getPath();
    private final String packageName;
    private int maxDepth = -1;

    public Finder(String packageName) {
        this.packageName = packageName;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void walk() {
        String packagePath = this.packageName.replace(".", "/");
        URL url = Thread.currentThread().getContextClassLoader().getResource(packagePath);
        if (!"file".equals(url.getProtocol())) {
            throw new IllegalArgumentException("This package name is not be included in the current propject.");
        }
        this.walk(url.getPath(), 0);
    }

    private void walk(String filePath, int depth) {
        File[] javaFiles;
        File file = new File(filePath);
        for (File javaFile : javaFiles = file.listFiles()) {
            if (javaFile.isDirectory()) {
                if (this.maxDepth >= 0 && this.maxDepth < depth) continue;
                this.walk(javaFile.getPath(), depth + 1);
                continue;
            }
            String path = javaFile.getPath();
            if (!(path = path.replace("\\", "/")).endsWith(".class")) continue;
            path = path.substring(path.indexOf(classPath) + classPath.length(), path.lastIndexOf("."));
            path = path.replace("/", ".");
            this.handleClass(javaFile, path, depth);
        }
    }

    protected void handleClass(File javaFile, String className, int depth) {
    }
}

