/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io;

import com.github.paganini2008.devtools.MatchMode;
import com.github.paganini2008.devtools.collection.MapUtils;
import com.github.paganini2008.devtools.date.DateUtils;
import com.github.paganini2008.devtools.io.FileUtils;
import com.github.paganini2008.devtools.io.IOUtils;
import com.github.paganini2008.devtools.io.RealtimeRefreshingResource;
import com.github.paganini2008.devtools.io.Resource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public abstract class RefreshingResource
implements Resource,
Serializable {
    private static final long serialVersionUID = 6728764457749444189L;
    private Map<String, String> config;

    protected abstract Map<String, String> getConfig() throws IOException;

    protected void onChange(Map<String, String> latest, Map<String, String> current) {
    }

    public synchronized boolean refresh() throws Exception {
        boolean hasChanged = false;
        Map<String, String> latest = this.getConfig();
        if (this.config != null) {
            HashMap<String, String> current = new HashMap<String, String>(this.config);
            boolean bl = hasChanged = !MapUtils.deepEquals(latest, current);
            if (hasChanged) {
                this.onChange(latest, current);
            }
        }
        this.config = latest;
        return hasChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(File file, String charset) throws IOException {
        FileOutputStream output = null;
        try {
            output = FileUtils.openOutputStream(file);
            this.store(output, charset);
        }
        finally {
            IOUtils.closeQuietly(output);
        }
    }

    public void store(OutputStream os, String charset) throws IOException {
        Properties p = MapUtils.toProperties(this.getConfig());
        p.store(os, "Created on " + DateUtils.format(System.currentTimeMillis()));
    }

    @Override
    public String getString(String name) {
        return this.getString(name, null);
    }

    @Override
    public String getString(String name, String defaultValue) {
        return MapUtils.get(this.config, name, String.class, defaultValue);
    }

    @Override
    public Byte getByte(String name) {
        return this.getByte(name, null);
    }

    @Override
    public Byte getByte(String name, Byte defaultValue) {
        return MapUtils.get(this.config, name, Byte.class, defaultValue);
    }

    @Override
    public Short getShort(String name) {
        return this.getShort(name, null);
    }

    @Override
    public Short getShort(String name, Short defaultValue) {
        return MapUtils.get(this.config, name, Short.class, defaultValue);
    }

    @Override
    public Integer getInteger(String name) {
        return this.getInteger(name, null);
    }

    @Override
    public Integer getInteger(String name, Integer defaultValue) {
        return MapUtils.get(this.config, name, Integer.class, defaultValue);
    }

    @Override
    public Long getLong(String name) {
        return this.getLong(name, null);
    }

    @Override
    public Long getLong(String name, Long defaultValue) {
        return MapUtils.get(this.config, name, Long.class, defaultValue);
    }

    @Override
    public Float getFloat(String name) {
        return this.getFloat(name, null);
    }

    @Override
    public Float getFloat(String name, Float defaultValue) {
        return MapUtils.get(this.config, name, Float.class, defaultValue);
    }

    @Override
    public Double getDouble(String name) {
        return this.getDouble(name, null);
    }

    @Override
    public Double getDouble(String name, Double defaultValue) {
        return MapUtils.get(this.config, name, Double.class, defaultValue);
    }

    @Override
    public Boolean getBoolean(String name) {
        return this.getBoolean(name, null);
    }

    @Override
    public Boolean getBoolean(String name, Boolean defaultValue) {
        return MapUtils.get(this.config, name, Boolean.class, defaultValue);
    }

    @Override
    public Map<String, String> toMap() {
        return this.config != null ? new HashMap<String, String>(this.config) : null;
    }

    @Override
    public Map<String, String> toMap(String substr, MatchMode mode) {
        Map<String, String> m = this.toMap();
        return MapUtils.toMatchedKeyMap(m, substr, mode);
    }

    public RealtimeRefreshingResource refresh(int interval) {
        return new RealtimeRefreshingResource(this, interval);
    }

    public String toString() {
        return this.config != null ? this.config.toString() : "";
    }
}

