/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io.filter;

import com.github.paganini2008.devtools.io.PathUtils;
import com.github.paganini2008.devtools.io.filter.FileFileFilter;
import java.io.File;

public class ExtensionFileFilter
extends FileFileFilter {
    private final String extension;
    private final boolean ignoreCase;

    public ExtensionFileFilter(String extension) {
        this(extension, true);
    }

    public ExtensionFileFilter(String extension, boolean ignoreCase) {
        this.extension = extension;
        this.ignoreCase = ignoreCase;
    }

    @Override
    public boolean accept(File file, String name) {
        if (super.accept(file)) {
            String ext = PathUtils.getExtension(name);
            return this.ignoreCase ? this.extension.equalsIgnoreCase(ext) : this.extension.equals(ext);
        }
        return false;
    }
}

