/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io.filter;

import com.github.paganini2008.devtools.io.SizeUnit;
import com.github.paganini2008.devtools.io.filter.DirectoryFileFilter;
import com.github.paganini2008.devtools.io.filter.ExtensionFileFilter;
import com.github.paganini2008.devtools.io.filter.FileFileFilter;
import com.github.paganini2008.devtools.io.filter.FileSizeFileFilter;
import com.github.paganini2008.devtools.io.filter.LastModifiedFileFilter;
import com.github.paganini2008.devtools.io.filter.LengthFileFilter;
import com.github.paganini2008.devtools.io.filter.LogicalFileFilter;
import com.github.paganini2008.devtools.io.filter.MatchNameFileFilter;
import com.github.paganini2008.devtools.io.filter.NameFileFilter;
import com.github.paganini2008.devtools.io.filter.Operator;

public class Filters {
    public static LogicalFileFilter findByName(String name, boolean ignoreCase) {
        return new NameFileFilter(name, ignoreCase);
    }

    public static LogicalFileFilter findByName(String name, MatchNameFileFilter.MatchMode matchMode) {
        return new MatchNameFileFilter(name, matchMode);
    }

    public static LogicalFileFilter findByLength(long length, SizeUnit sizeUnit, Operator operator) {
        return new LengthFileFilter(length, sizeUnit, operator);
    }

    public static LogicalFileFilter findByExtension(String extension, boolean ignoreCase) {
        return new ExtensionFileFilter(extension, ignoreCase);
    }

    public static LogicalFileFilter findByLastModified(long lastModified, Operator operator) {
        return new LastModifiedFileFilter(lastModified, operator);
    }

    public static LogicalFileFilter hasSubfolders(int size, Operator operator) {
        return new FileSizeFileFilter(size, operator);
    }

    public static LogicalFileFilter isFile() {
        return new FileFileFilter();
    }

    public static LogicalFileFilter isDirectory() {
        return new DirectoryFileFilter();
    }

    private Filters() {
    }
}

