/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.jdbc;

import com.github.paganini2008.devtools.jdbc.PageRequest;
import com.github.paganini2008.devtools.jdbc.PageResponse;
import com.github.paganini2008.devtools.jdbc.ResultSetSlice;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

public class SimplePageResponse<T>
implements PageResponse<T>,
Serializable {
    private static final long serialVersionUID = 2344670418378384182L;
    private final int pageNumber;
    private final int totalPages;
    private final int totalRecords;
    private final PageRequest pageRequest;
    private final transient ResultSetSlice<T> resultSlice;

    public SimplePageResponse(PageRequest pageRequest, ResultSetSlice<T> resultSlice) {
        this.pageNumber = pageRequest.getPageNumber();
        this.totalRecords = resultSlice.totalCount();
        this.totalPages = (this.totalRecords + pageRequest.getPageSize() - 1) / pageRequest.getPageSize();
        this.pageRequest = pageRequest;
        this.resultSlice = resultSlice;
    }

    @Override
    public boolean isEmpty() {
        return this.totalRecords == 0;
    }

    @Override
    public boolean isLastPage() {
        return this.pageNumber == this.getTotalPages();
    }

    @Override
    public boolean isFirstPage() {
        return this.pageNumber == 1;
    }

    @Override
    public boolean hasNextPage() {
        return this.pageNumber < this.getTotalPages();
    }

    @Override
    public boolean hasPreviousPage() {
        return this.pageNumber > 1;
    }

    @Override
    public Iterator<PageResponse<T>> iterator() {
        return new PageIterator();
    }

    @Override
    public int getTotalPages() {
        return this.totalPages;
    }

    @Override
    public int getTotalRecords() {
        return this.totalRecords;
    }

    @Override
    public int getOffset() {
        return this.pageRequest.getOffset();
    }

    @Override
    public int getPageSize() {
        return this.pageRequest.getPageSize();
    }

    @Override
    public PageResponse<T> setPage(int pageNumber) {
        return new SimplePageResponse<T>(this.pageRequest.set(pageNumber), this.resultSlice);
    }

    @Override
    public PageResponse<T> lastPage() {
        int lastPage = this.getTotalPages();
        return this.isLastPage() ? this : this.setPage(lastPage);
    }

    @Override
    public PageResponse<T> firstPage() {
        return this.isFirstPage() ? this : new SimplePageResponse<T>(this.pageRequest.first(), this.resultSlice);
    }

    @Override
    public PageResponse<T> nextPage() {
        return this.hasNextPage() ? new SimplePageResponse<T>(this.pageRequest.next(), this.resultSlice) : this;
    }

    @Override
    public PageResponse<T> previousPage() {
        return this.hasPreviousPage() ? new SimplePageResponse<T>(this.pageRequest.previous(), this.resultSlice) : this;
    }

    @Override
    public List<T> getContent() {
        return this.resultSlice.list(this.pageRequest.getPageSize(), this.pageRequest.getOffset());
    }

    class PageIterator
    implements Iterator<PageResponse<T>> {
        private PageResponse<T> current;

        PageIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.current == null || this.current.hasNextPage();
        }

        @Override
        public PageResponse<T> next() {
            this.current = this.current == null ? SimplePageResponse.this : this.current.nextPage();
            return this.current;
        }
    }
}

