/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.logging;

import com.github.paganini2008.devtools.logging.Configuration;
import com.github.paganini2008.devtools.logging.DefaultLoggerFactory;
import java.io.UnsupportedEncodingException;
import java.util.logging.Handler;
import java.util.logging.Logger;

public class ExtendedLoggerFactory
extends DefaultLoggerFactory {
    private Configuration configuration = new Configuration();

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public Logger getLogger(String name) {
        Logger logger = super.getLogger(name);
        for (Handler handler : this.configuration.getHandlers(name)) {
            try {
                handler.setEncoding(this.getCharset());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            handler.setFormatter(this.getFormatter());
            handler.setFilter(this.getFilter());
            logger.addHandler(handler);
        }
        logger.setLevel(this.configuration.getLevel(name));
        return logger;
    }
}

