/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class SimpleFormatter
extends Formatter {
    private static final String lineSeparator = System.getProperty("line.separator");
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss a z", Locale.getDefault());

    @Override
    public synchronized String format(LogRecord record) {
        StringBuffer info = new StringBuffer();
        info.append(dateFormat.format(record.getMillis()));
        info.append(": [");
        info.append(record.getLevel().getName().toUpperCase());
        info.append("] ");
        String message = this.formatMessage(record);
        info.append(message);
        info.append(lineSeparator);
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            record.getThrown().printStackTrace(pw);
            pw.close();
            info.append(sw.toString());
        }
        return info.toString();
    }
}

