/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.logging;

import com.github.paganini2008.devtools.io.SizeUnit;
import com.github.paganini2008.devtools.logging.ExtendedLoggerFactory;
import com.github.paganini2008.devtools.logging.Handlers;
import com.github.paganini2008.devtools.logging.Log;
import com.github.paganini2008.devtools.logging.LogFactory;
import com.github.paganini2008.devtools.logging.LoggerFactory;
import com.github.paganini2008.devtools.logging.LoggerFactoryBuilder;
import java.io.IOException;
import java.util.UUID;

public class TestMain {
    private static void initialize() throws IOException {
        final ExtendedLoggerFactory loggerFactory = new ExtendedLoggerFactory();
        loggerFactory.getConfiguration().addHandler("file", Handlers.fileHandler("d:/sql/test.log", SizeUnit.MB.toBytes(10L).intValue(), "info"));
        loggerFactory.getConfiguration().bindHandler("com.github.paganini2008.http", new String[]{"file"});
        LogFactory.initialize(new LoggerFactoryBuilder(){

            @Override
            public LoggerFactory getFactory() {
                return loggerFactory;
            }
        });
    }

    public static void main(String[] args) {
        Log logger = LogFactory.getLog(TestMain.class);
        for (int i = 0; i < 100000; ++i) {
            logger.info(UUID.randomUUID().toString());
        }
    }

    static {
        try {
            TestMain.initialize();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

