/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.multithreads;

import com.github.paganini2008.devtools.multithreads.AtomicUnsignedLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class AtomicDouble
extends Number {
    private static final long serialVersionUID = -5035478790557265664L;
    private static final AtomicLongFieldUpdater<AtomicDouble> updater = AtomicLongFieldUpdater.newUpdater(AtomicDouble.class, "value");
    private volatile long value;
    private final long maxValue;
    private final double initialValue;

    public AtomicDouble() {
        this(0.0);
    }

    public AtomicDouble(double initialValue) {
        this(initialValue, Long.MAX_VALUE);
    }

    public AtomicDouble(double initialValue, long maxValue) {
        this.value = Double.doubleToRawLongBits(initialValue);
        this.initialValue = initialValue;
        this.maxValue = maxValue;
    }

    public double get() {
        return Double.longBitsToDouble(this.value);
    }

    public void set(double newValue) {
        if (newValue >= this.initialValue && newValue <= (double)this.maxValue) {
            long next;
            this.value = next = Double.doubleToRawLongBits(newValue);
        }
        throw new IllegalArgumentException("New value must >= " + this.initialValue + " and <= " + this.maxValue + ".");
    }

    public double getAndSet(double newValue) {
        long next = Double.doubleToRawLongBits(newValue);
        return Double.longBitsToDouble(updater.getAndSet(this, next));
    }

    public boolean compareAndSet(double expect, double update) {
        return updater.compareAndSet(this, Double.doubleToRawLongBits(expect), Double.doubleToRawLongBits(update));
    }

    public boolean weakCompareAndSet(double expect, double update) {
        return updater.weakCompareAndSet(this, Double.doubleToRawLongBits(expect), Double.doubleToRawLongBits(update));
    }

    public double getAndAdd(double delta) {
        double currentVal;
        double nextVal;
        long next;
        long current;
        while (!updater.compareAndSet(this, current, next = Double.doubleToRawLongBits(nextVal = (currentVal = Double.longBitsToDouble(current = this.value)) >= (double)this.maxValue - delta ? this.initialValue : currentVal + delta))) {
        }
        return currentVal;
    }

    public double addAndGet(double delta) {
        double currentVal;
        double nextVal;
        long next;
        long current;
        while (!updater.compareAndSet(this, current, next = Double.doubleToRawLongBits(nextVal = (currentVal = Double.longBitsToDouble(current = this.value)) >= (double)this.maxValue - delta ? this.initialValue : currentVal + delta))) {
        }
        return nextVal;
    }

    public String toString() {
        return Double.toString(this.get());
    }

    public int hashCode() {
        int result = 37;
        return result += Double.hashCode(this.get());
    }

    public boolean equals(Object other) {
        if (other instanceof AtomicUnsignedLong) {
            AtomicUnsignedLong integer = (AtomicUnsignedLong)other;
            return (double)integer.get() == this.get();
        }
        return false;
    }

    @Override
    public int intValue() {
        return (int)this.get();
    }

    @Override
    public long longValue() {
        return (long)this.get();
    }

    @Override
    public float floatValue() {
        return (float)this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }
}

