/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.multithreads.latch;

import com.github.paganini2008.devtools.multithreads.ThreadUtils;
import com.github.paganini2008.devtools.multithreads.latch.Latch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class CounterLatch
implements Latch {
    private final AtomicInteger counter = new AtomicInteger(0);
    private final int maxPermits;
    private final Lock lock;
    private final Condition condition;
    private final long startTime;

    public CounterLatch(int maxPermits) {
        this(maxPermits, new ReentrantLock());
    }

    public CounterLatch(int maxPermits, Lock lock) {
        this.maxPermits = maxPermits;
        this.lock = lock;
        this.condition = lock.newCondition();
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public long availablePermits() {
        return this.maxPermits - this.counter.get();
    }

    @Override
    public boolean acquire() {
        while (true) {
            this.lock.lock();
            try {
                if (this.counter.get() < this.maxPermits) {
                    this.counter.incrementAndGet();
                    boolean bl = true;
                    return bl;
                }
                try {
                    this.condition.await();
                    continue;
                }
                catch (InterruptedException e) {
                    this.lock.unlock();
                }
            }
            finally {
                this.lock.unlock();
                continue;
            }
            break;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acquire(long timeout, TimeUnit timeUnit) {
        long begin = System.nanoTime();
        long nanosTimeout = TimeUnit.NANOSECONDS.convert(timeout, timeUnit);
        while (true) {
            this.lock.lock();
            try {
                if (this.counter.get() < this.maxPermits) {
                    this.counter.incrementAndGet();
                    boolean bl = true;
                    return bl;
                }
                if (nanosTimeout <= 0L) break;
                try {
                    this.condition.awaitNanos(nanosTimeout);
                }
                catch (InterruptedException e) {
                    this.lock.unlock();
                    break;
                }
                long elapsed = System.nanoTime() - begin;
                nanosTimeout -= elapsed;
                continue;
            }
            finally {
                this.lock.unlock();
                continue;
            }
            break;
        }
        return false;
    }

    @Override
    public boolean tryAcquire() {
        if (this.counter.get() < this.maxPermits) {
            this.counter.incrementAndGet();
            return true;
        }
        return false;
    }

    @Override
    public void release() {
        if (!this.isLocked()) {
            return;
        }
        this.lock.lock();
        this.counter.decrementAndGet();
        this.condition.signalAll();
        this.lock.unlock();
    }

    @Override
    public long join() {
        while (this.counter.get() > 0) {
            ThreadUtils.randomSleep(1000L);
        }
        return System.currentTimeMillis() - this.startTime;
    }

    @Override
    public boolean isLocked() {
        return this.counter.get() > 0;
    }

    public static Latch newSingleLatch() {
        return new CounterLatch(1);
    }

    public static Latch newUnlimitedLatch() {
        return new CounterLatch(Integer.MAX_VALUE);
    }
}

