/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.multithreads.latch;

import com.github.paganini2008.devtools.Sequence;
import com.github.paganini2008.devtools.multithreads.AtomicUnsignedLong;
import com.github.paganini2008.devtools.multithreads.ThreadPool;
import com.github.paganini2008.devtools.multithreads.ThreadUtils;
import com.github.paganini2008.devtools.multithreads.latch.Latch;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class FairLatch
implements Latch {
    private final ThreadLocal<AtomicUnsignedLong> threadLocal = new ThreadLocal<AtomicUnsignedLong>(){

        @Override
        protected AtomicUnsignedLong initialValue() {
            return new AtomicUnsignedLong(0L);
        }
    };
    private final AtomicUnsignedLong sequence = new AtomicUnsignedLong(0L);
    private final AtomicInteger counter = new AtomicInteger(0);
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final long startTime = System.currentTimeMillis();

    @Override
    public long availablePermits() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acquire() {
        AtomicUnsignedLong serial = this.threadLocal.get();
        long ticket = serial.getAndIncrement();
        while (true) {
            this.lock.lock();
            try {
                if (ticket == this.sequence.get()) {
                    this.counter.incrementAndGet();
                    boolean bl = true;
                    return bl;
                }
                try {
                    this.condition.await();
                    continue;
                }
                catch (InterruptedException e) {
                    this.lock.unlock();
                }
            }
            finally {
                this.lock.unlock();
                continue;
            }
            break;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acquire(long timeout, TimeUnit timeUnit) {
        long begin = System.nanoTime();
        long nanosTimeout = TimeUnit.NANOSECONDS.convert(timeout, timeUnit);
        AtomicUnsignedLong serial = this.threadLocal.get();
        long ticket = serial.getAndIncrement();
        while (true) {
            this.lock.lock();
            try {
                if (ticket == this.sequence.get()) {
                    this.counter.incrementAndGet();
                    boolean bl = true;
                    return bl;
                }
                if (nanosTimeout <= 0L) break;
                try {
                    this.condition.awaitNanos(nanosTimeout);
                }
                catch (InterruptedException e) {
                    this.lock.unlock();
                    break;
                }
                long elapsed = System.nanoTime() - begin;
                nanosTimeout -= elapsed;
                continue;
            }
            finally {
                this.lock.unlock();
                continue;
            }
            break;
        }
        return false;
    }

    @Override
    public boolean tryAcquire() {
        AtomicUnsignedLong serial = this.threadLocal.get();
        long ticket = serial.getAndIncrement();
        return ticket == this.sequence.get();
    }

    @Override
    public void release() {
        this.lock.lock();
        this.sequence.getAndIncrement();
        this.counter.decrementAndGet();
        this.condition.signalAll();
        this.lock.unlock();
    }

    @Override
    public boolean isLocked() {
        return this.counter.get() > 0;
    }

    @Override
    public long join() {
        while (this.counter.get() > 0) {
            ThreadUtils.randomSleep(1000L);
        }
        return System.currentTimeMillis() - this.startTime;
    }

    public static void main(String[] args) throws IOException {
        FairLatch latch = new FairLatch();
        ThreadPool threads = ThreadUtils.commonPool(10);
        AtomicInteger score = new AtomicInteger();
        for (int i : Sequence.forEach(0, 1000)) {
            if (!latch.acquire(1L, TimeUnit.SECONDS)) continue;
            threads.execute(() -> {
                System.out.println(ThreadUtils.currentThreadName() + ": " + i);
                score.incrementAndGet();
                latch.release();
            });
        }
        latch.join();
        threads.shutdown();
        System.out.println(score);
    }
}

