/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.primitives;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.CharValueOverflowException;
import com.github.paganini2008.devtools.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public abstract class Chars {
    public static final char CR = '\r';
    public static final char LF = '\n';
    private static final int MERGE_SORT_THRESHOLD = 10;
    public static final char[] EMPTY_ARRAY = new char[0];
    public static final Character[] EMPTY_OBJECT_ARRAY = new Character[0];

    public static char[] clone(char[] array) {
        return array != null ? (char[])array.clone() : null;
    }

    public static int length(char[] array) {
        return array != null ? array.length : 0;
    }

    public static char[][] create(int yLength, int xLength, char defaultValue) {
        char[][] array = new char[yLength][xLength];
        for (int i = 0; i < yLength; ++i) {
            array[i] = Chars.create(xLength, defaultValue);
        }
        return array;
    }

    public static char[] create(int length, char defaultValue) {
        char[] array = new char[length];
        if (defaultValue != '\u0000') {
            for (int i = 0; i < length; ++i) {
                array[i] = defaultValue;
            }
        }
        return array;
    }

    public static boolean isNotEmpty(char[] args) {
        return !Chars.isEmpty(args);
    }

    public static boolean isEmpty(char[] args) {
        return args != null ? args.length == 0 : true;
    }

    public static boolean notContains(char[] a, int b) {
        return !Chars.contains(a, b);
    }

    public static boolean contains(char[] a, int b) {
        return Chars.indexOf(a, b) != -1;
    }

    public static int indexOf(char[] a, int b) {
        return Chars.indexOf(a, b, 0, a.length);
    }

    public static int indexOf(char[] a, int b, int start, int end) {
        if (a == null) {
            return -1;
        }
        if (start < 0) {
            return -1;
        }
        int l = Math.min(a.length, end);
        for (int i = start; i < l; ++i) {
            if (a[i] != b) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(char[] a, char b) {
        return Chars.lastIndexOf(a, b, a.length - 1);
    }

    public static int lastIndexOf(char[] a, char b, int start) {
        if (a == null || start < 0) {
            return -1;
        }
        for (int i = Math.min(start, a.length - 1); i >= 0; --i) {
            if (a[i] != b) continue;
            return i;
        }
        return -1;
    }

    public static char[] concat(char[] left, char[] right) {
        Assert.isNull(left, "Left array must not be null.", new Object[0]);
        Assert.isNull(right, "Right array must not be null.", new Object[0]);
        char[] chars = Chars.copy(left, 0, left.length + right.length);
        Chars.hardCopy(right, 0, chars, left.length, right.length);
        return chars;
    }

    public static char[] add(char[] array, char a) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        char[] chars = Chars.copy(array, array.length + 1);
        chars[chars.length - 1] = a;
        return chars;
    }

    public static char[] remove(char[] array, char a) {
        int index = Chars.indexOf(array, a);
        return index != -1 ? Chars.removeAt(array, index) : array;
    }

    public static char[] removeAt(char[] array, int index) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        int length = array.length;
        if (index < 0) {
            index = length - Math.abs(index);
        }
        if (index >= 0 && index < length) {
            char[] target = Chars.create(length - 1, '\u0000');
            Chars.hardCopy(array, 0, target, 0, index);
            Chars.hardCopy(array, index + 1, target, index, length - index - 1);
            return target;
        }
        throw new ArrayIndexOutOfBoundsException("Bad index: " + index);
    }

    public static char[] copy(char[] array) {
        return Chars.copy(array, array.length);
    }

    public static char[] copy(char[] array, int length) {
        return Chars.copy(array, 0, length);
    }

    public static char[] copy(char[] array, int startIndex, int length) {
        return Chars.copy(array, startIndex, length, '\u0000');
    }

    public static char[] copy(char[] array, int startIndex, int length, char defaultValue) {
        char[] target = Chars.create(length, defaultValue);
        Chars.hardCopy(array, startIndex, target, 0, length);
        return target;
    }

    private static void hardCopy(char[] src, int srcFrom, char[] dest, int destFrom, int length) {
        System.arraycopy(src, srcFrom, dest, destFrom, Math.min(src.length, length));
    }

    public static Character[] toWrappers(char[] array) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        int l = array.length;
        Character[] results = new Character[l];
        int i = 0;
        for (char arg : array) {
            results[i++] = Character.valueOf(arg);
        }
        return results;
    }

    public static char[] toPrimitives(Character[] array) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        int l = array.length;
        char[] results = new char[l];
        int i = 0;
        for (Character arg : array) {
            if (arg == null) continue;
            results[i++] = arg.charValue();
        }
        return Chars.ensureCapacity(results, i);
    }

    public static char[] ensureCapacity(char[] array, int index) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        int length = array.length;
        if (index != length) {
            return Chars.copy(array, 0, Math.min(index, length));
        }
        return array;
    }

    public static char[] expandCapacity(char[] array) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        return Chars.expandCapacity(array, array.length);
    }

    public static char[] expandCapacity(char[] array, int size) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        int length = array.length;
        return Chars.copy(array, Math.max(length + size, length));
    }

    public static String toString(char[] array) {
        return "[" + Chars.join(array) + "]";
    }

    public static String join(char[] array) {
        return Chars.join(array, ",");
    }

    public static String join(char[] array, String delimiter) {
        if (Chars.isEmpty(array)) {
            return "";
        }
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuilder str = new StringBuilder();
        int l = array.length;
        for (int i = 0; i < l; ++i) {
            str.append(array[i]);
            if (i == l - 1) continue;
            str.append(delimiter);
        }
        return str.toString();
    }

    public static String join(char[] left, char[] right, String delimiter) {
        return Chars.join(left, right, delimiter, delimiter);
    }

    public static String join(char[] left, char[] right, String conjunction, String delimiter) {
        if (Chars.isEmpty(left) || Chars.isEmpty(right)) {
            return "";
        }
        if (conjunction == null) {
            conjunction = "";
        }
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuilder content = new StringBuilder();
        int l = Math.min(left.length, right.length);
        for (int i = 0; i < l; ++i) {
            content.append(left[i]).append(conjunction).append(right[i]);
            if (i == l - 1) continue;
            content.append(delimiter);
        }
        return content.toString();
    }

    public static void swap(char[] x, int a, int b) {
        char t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void sort(char[] array, int low, int high, boolean asc) {
        for (int i = low; i < high; ++i) {
            for (int j = i; j > low; --j) {
                if (!(asc ? array[j - 1] > array[j] : array[j - 1] < array[j])) continue;
                Chars.swap(array, j - 1, j);
            }
        }
    }

    public static void asc(char[] array) {
        if (Chars.isNotEmpty(array)) {
            char[] aux = (char[])array.clone();
            Chars.mergeSort(aux, array, 0, array.length, true);
        }
    }

    public static void desc(char[] array) {
        if (Chars.isNotEmpty(array)) {
            char[] aux = (char[])array.clone();
            Chars.mergeSort(aux, array, 0, array.length, false);
        }
    }

    private static void mergeSort(char[] src, char[] dest, int low, int high, boolean asc) {
        int length = high - low;
        if (length < 10) {
            Chars.sort(dest, low, high, asc);
            return;
        }
        int mid = (high + low) / 2;
        Chars.mergeSort(dest, src, low, mid, asc);
        Chars.mergeSort(dest, src, mid, high, asc);
        int i = low;
        int p = low;
        int q = mid;
        while (p < mid && q < high) {
            if (asc ? src[p] <= src[q] : src[p] > src[q]) {
                dest[i++] = src[p++];
                continue;
            }
            dest[i++] = src[q++];
        }
        while (p < mid && i < high) {
            dest[i++] = src[p++];
        }
        while (q < high && i < high) {
            dest[i++] = src[q++];
        }
    }

    public static char[] unionAll(char[] left, char[] right) {
        if (left == null && right == null) {
            return null;
        }
        if (left != null && right == null) {
            return left;
        }
        if (left == null && right != null) {
            return right;
        }
        char[] total = new char[left.length + right.length];
        int i = 0;
        for (char s : left) {
            total[i++] = s;
        }
        for (char s : right) {
            total[i++] = s;
        }
        return Chars.ensureCapacity(total, i);
    }

    public static char[] union(char[] left, char[] right) {
        if (left == null && right == null) {
            return null;
        }
        if (left != null && right == null) {
            return left;
        }
        if (left == null && right != null) {
            return right;
        }
        char[] total = new char[left.length + right.length];
        int i = 0;
        for (char s : left) {
            if (Chars.contains(total, s)) continue;
            total[i++] = s;
        }
        for (char s : right) {
            if (Chars.contains(total, s)) continue;
            total[i++] = s;
        }
        return Chars.ensureCapacity(total, i);
    }

    public static char[] minus(char[] left, char[] right) {
        int i;
        if (left == null && right == null) {
            return null;
        }
        if (left != null && right == null) {
            return left;
        }
        if (left == null && right != null) {
            return right;
        }
        char[] result = new char[right.length];
        for (i = 0; i < left.length; ++i) {
            if (Chars.contains(right, left[i])) continue;
            result[i++] = left[i];
        }
        return Chars.ensureCapacity(result, i);
    }

    public static char[] intersect(char[] left, char[] right) {
        int i;
        if (left == null && right == null) {
            return null;
        }
        if (left != null && right == null) {
            return left;
        }
        if (left == null && right != null) {
            return right;
        }
        char[] result = new char[right.length];
        for (i = 0; i < left.length; ++i) {
            if (!Chars.contains(right, left[i])) continue;
            result[i++] = left[i];
        }
        return Chars.ensureCapacity(result, i);
    }

    public static char max(char[] array) {
        Assert.isTrue(Chars.isEmpty(array), "Empty array.", new Object[0]);
        char max = array[0];
        for (int i = 1; i < array.length; ++i) {
            max = max >= array[i] ? max : array[i];
        }
        return max;
    }

    public static char min(char[] array) {
        Assert.isTrue(Chars.isEmpty(array), "Empty array.", new Object[0]);
        char min = array[0];
        for (int i = 1; i < array.length; ++i) {
            min = min <= array[i] ? min : array[i];
        }
        return min;
    }

    public static char[] toArray(Collection<Character> c) {
        Assert.isNull(c, "Source collection must not be null.", new Object[0]);
        char[] array = new char[c.size()];
        int i = 0;
        for (Character a : c) {
            if (a == null) continue;
            array[i++] = a.charValue();
        }
        return Chars.ensureCapacity(array, i);
    }

    public static List<Character> toList(char[] array) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        ArrayList<Character> set = new ArrayList<Character>(array.length);
        for (char a : array) {
            set.add(Character.valueOf(a));
        }
        return set;
    }

    public static void reverse(char[] src) {
        int l = src.length;
        for (int i = 0; i < l / 2; ++i) {
            char a;
            char t = src[i];
            int j = l - 1 - i;
            src[i] = a = src[j];
            src[j] = t;
        }
    }

    public static char cast(boolean b) {
        return b ? (char)'Y' : 'N';
    }

    public static char[] casts(boolean[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        char[] result = new char[value.length];
        int i = 0;
        for (boolean val : value) {
            result[i++] = Chars.cast(val);
        }
        return result;
    }

    public static char cast(int value) {
        if (value < 0 || value > 65535) {
            throw CharValueOverflowException.causedByChar(value);
        }
        return (char)value;
    }

    public static char[] casts(int[] value) {
        return Chars.casts(value, true);
    }

    public static char[] casts(int[] value, boolean thrown) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        char[] result = new char[value.length];
        int i = 0;
        for (int val : value) {
            try {
                result[i++] = Chars.cast(val);
            }
            catch (IllegalArgumentException e) {
                if (!thrown) continue;
                throw e;
            }
        }
        return Chars.ensureCapacity(result, i);
    }

    public static Character valueOf(Boolean b) {
        return Chars.valueOf(b, null);
    }

    public static Character valueOf(Boolean b, Character defaultValue) {
        if (b == null) {
            return defaultValue;
        }
        return Character.valueOf(Chars.cast(b));
    }

    public static Character valueOf(Integer i) {
        return Chars.valueOf(i, null);
    }

    public static Character valueOf(Integer i, Character defaultValue) {
        if (i == null) {
            return defaultValue;
        }
        try {
            return Character.valueOf(Chars.cast(i));
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
    }

    public static List<Character> toCharacterList(CharSequence value) {
        ArrayList<Character> list = new ArrayList<Character>();
        for (int i = 0; i < value.length(); ++i) {
            list.add(Character.valueOf(value.charAt(i)));
        }
        return list;
    }

    public static Character[] toCharacterArray(CharSequence value) {
        int length = value.length();
        Character[] result = new Character[length];
        for (int i = 0; i < length; ++i) {
            result[i++] = Character.valueOf(value.charAt(i));
        }
        return result;
    }

    public static int hashCode(char arg) {
        return arg;
    }

    public static boolean deepEquals(char[] left, char[] right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return right == null;
        }
        if (right == null) {
            return false;
        }
        int length = left.length;
        if (length != right.length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (left[i] == right[i]) continue;
            return false;
        }
        return true;
    }

    public static int deepHashCode(char[] args) {
        int hash = 0;
        for (int i = 0; i < args.length; ++i) {
            hash += Chars.hashCode(args[i]);
        }
        return hash;
    }

    public static Character valueOf(String str) {
        return Chars.valueOf(str, null);
    }

    public static Character valueOf(String str, Character defaultValue) {
        if (StringUtils.isBlank(str)) {
            return defaultValue;
        }
        return Character.valueOf(str.charAt(0));
    }

    public static boolean isAlpha(char ch) {
        return Chars.isUpper(ch) || Chars.isLower(ch);
    }

    public static boolean isPrintable(char ch) {
        return ch >= ' ' && ch < '\u007f';
    }

    public static boolean isControl(char ch) {
        return ch < ' ' || ch == '\u007f';
    }

    public static boolean isAscii(char ch) {
        return ch < '\u0080';
    }

    public static boolean isUpper(char ch) {
        return ch >= 'A' && ch <= 'Z';
    }

    public static boolean isLower(char ch) {
        return ch >= 'a' && ch <= 'z';
    }

    public static boolean isNumber(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static boolean isAlphaNumber(char ch) {
        return Chars.isAlpha(ch) || Chars.isNumber(ch);
    }

    public static String toUnicode(char ch) {
        if (ch < '\u0010') {
            return "\\u000" + Integer.toHexString(ch);
        }
        if (ch < '\u0100') {
            return "\\u00" + Integer.toHexString(ch);
        }
        if (ch < '\u1000') {
            return "\\u0" + Integer.toHexString(ch);
        }
        return "\\u" + Integer.toHexString(ch);
    }

    public static String[] toStringArray(char[] args) {
        int l = args.length;
        String[] array = new String[l];
        for (int i = 0; i < l; ++i) {
            array[i] = String.valueOf(args[i]);
        }
        return array;
    }

    public static boolean isSameLength(char[] left, char[] right) {
        if (left == null) {
            return right != null ? right.length == 0 : true;
        }
        if (right == null) {
            return left != null ? left.length == 0 : true;
        }
        return left.length == right.length;
    }

    public static boolean isSubarray(char[] left, char[] right) {
        if (Chars.isEmpty(left) || Chars.isEmpty(right) || left.length < right.length) {
            return false;
        }
        for (int i = 0; i < left.length; ++i) {
            if (left[i] != right[0]) continue;
            boolean f = true;
            for (int j = 1; j < right.length; ++j) {
                if (i + j == left.length) {
                    return false;
                }
                if (left[i + j] == right[j]) continue;
                f = false;
                break;
            }
            if (!f) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(char[] left, char[] right) {
        if (Chars.isEmpty(left) || Chars.isEmpty(right) || left.length < right.length) {
            return false;
        }
        for (char c : right) {
            if (!Chars.notContains(left, c)) continue;
            return false;
        }
        return true;
    }

    public static boolean same(char[] array) {
        if (Chars.isEmpty(array)) {
            return false;
        }
        for (int i = 1; i < array.length; ++i) {
            if (array[i] - array[i - 1] == 0) continue;
            return false;
        }
        return true;
    }

    public static void leftScroll(char[] src, int n) {
        if (Chars.isNotEmpty(src) && n > 0) {
            int l = src.length;
            Chars.rightScroll(src, l - n);
        }
    }

    public static void rightScroll(char[] src, int n) {
        if (Chars.isNotEmpty(src) && n > 0) {
            int l = src.length;
            Chars.rightScroll(src, 0, l - (n %= l) - 1);
            Chars.rightScroll(src, l - n, l - 1);
            Chars.rightScroll(src, 0, l - 1);
        }
    }

    private static void rightScroll(char[] src, int n, int m) {
        while (n < m) {
            Chars.swap(src, m, n);
            ++n;
            --m;
        }
    }

    public static void shuffle(char[] src) {
        Chars.shuffle(src, ThreadLocalRandom.current());
    }

    public static void shuffle(char[] src, Random rn) {
        for (int i = src.length; i > 1; --i) {
            Chars.swap(src, i - 1, rn.nextInt(i));
        }
    }

    public static Comparator<char[]> defaultComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static int compare(char a, char b) {
        return a - b;
    }

    private static enum LexicographicalComparator implements Comparator<char[]>
    {
        INSTANCE;


        @Override
        public int compare(char[] left, char[] right) {
            int minLength = Math.min(left.length, right.length);
            for (int i = 0; i < minLength; ++i) {
                int result = Chars.compare(left[i], right[i]);
                if (result == 0) continue;
                return result;
            }
            return left.length - right.length;
        }
    }
}

