/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.primitives;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.NumberOverflowException;
import com.github.paganini2008.devtools.NumberRange;
import com.github.paganini2008.devtools.NumberUtils;
import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.collection.LruMap;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public abstract class Shorts {
    public static final short[] EMPTY_SHORT_ARRAY = new short[0];
    public static final Short[] EMPTY_SHORT_OBJECT_ARRAY = new Short[0];
    private static final LruMap<String, Short> cache = new LruMap(1024);
    public static final int BYTES = 2;
    public static final short MAX_POWER_OF_TWO = 16384;

    public static void clearCache() {
        cache.clear();
    }

    public static short[] clone(short[] array) {
        return array != null ? (short[])array.clone() : null;
    }

    public static int length(short[] array) {
        return array != null ? array.length : 0;
    }

    public static short[][] create(int yLength, int xLength, short defaultValue) {
        short[][] array = new short[yLength][xLength];
        for (int i = 0; i < yLength; ++i) {
            array[i] = Shorts.create(xLength, defaultValue);
        }
        return array;
    }

    public static short[] create(int length, short defaultValue) {
        short[] array = new short[length];
        if (defaultValue != 0) {
            for (int i = 0; i < length; ++i) {
                array[i] = defaultValue;
            }
        }
        return array;
    }

    public static boolean isNotEmpty(short[] args) {
        return !Shorts.isEmpty(args);
    }

    public static boolean isEmpty(short[] args) {
        return args != null ? args.length == 0 : true;
    }

    public static boolean notContains(short[] a, short b) {
        return !Shorts.contains(a, b);
    }

    public static boolean contains(short[] a, short b) {
        return Shorts.indexOf(a, b) != -1;
    }

    public static int indexOf(short[] a, short b) {
        return Shorts.indexOf(a, b, 0);
    }

    public static int indexOf(short[] a, short b, int start) {
        return Shorts.indexOf(a, b, start, a.length);
    }

    public static int indexOf(short[] a, short b, int start, int end) {
        if (a == null) {
            return -1;
        }
        if (start < 0) {
            return -1;
        }
        int l = Math.min(a.length, end);
        for (int i = start; i < l; ++i) {
            if (a[i] != b) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(short[] a, short b) {
        return Shorts.lastIndexOf(a, b, a.length - 1);
    }

    public static int lastIndexOf(short[] a, short b, int start) {
        if (a == null || start < 0) {
            return -1;
        }
        for (int i = Math.min(start, a.length - 1); i >= 0; --i) {
            if (a[i] != b) continue;
            return i;
        }
        return -1;
    }

    public static short[] concat(short[] left, short[] right) {
        Assert.isNull(left, "Left array must not be null.", new Object[0]);
        Assert.isNull(right, "Right array must not be null.", new Object[0]);
        short[] shorts = Shorts.copy(left, 0, left.length + right.length);
        Shorts.hardCopy(right, 0, shorts, left.length, right.length);
        return shorts;
    }

    public static short[] add(short[] array, short a) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        short[] shorts = Shorts.copy(array, array.length + 1);
        shorts[shorts.length - 1] = a;
        return shorts;
    }

    public static short[] remove(short[] array, short a) {
        int index = Shorts.indexOf(array, a);
        return index != -1 ? Shorts.removeAt(array, index) : array;
    }

    public static short[] removeAt(short[] array, int index) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        int length = array.length;
        if (index < 0) {
            index = length - Math.abs(index);
        }
        if (index >= 0 && index < length) {
            short[] target = Shorts.create(length - 1, (short)0);
            Shorts.hardCopy(array, 0, target, 0, index);
            Shorts.hardCopy(array, index + 1, target, index, length - index - 1);
            return target;
        }
        throw new ArrayIndexOutOfBoundsException("Bad index: " + index);
    }

    public static short[] copy(short[] array) {
        return Shorts.copy(array, array.length);
    }

    public static short[] copy(short[] array, int length) {
        return Shorts.copy(array, 0, length);
    }

    public static short[] copy(short[] array, int startIndex, int length) {
        return Shorts.copy(array, startIndex, length, (short)0);
    }

    public static short[] copy(short[] array, int startIndex, int length, short defaultValue) {
        short[] target = Shorts.create(length, defaultValue);
        Shorts.hardCopy(array, startIndex, target, 0, length);
        return target;
    }

    private static void hardCopy(short[] src, int srcFrom, short[] dest, int destFrom, int length) {
        System.arraycopy(src, srcFrom, dest, destFrom, Math.min(src.length, length));
    }

    public static Short[] toWrappers(byte[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        Short[] result = new Short[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = value[i];
        }
        return result;
    }

    public static Short[] toWrappers(short[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        Short[] result = new Short[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = value[i];
        }
        return result;
    }

    public static short[] toPrimitives(Short[] array) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        int l = array.length;
        short[] results = new short[l];
        int i = 0;
        for (Short arg : array) {
            if (arg == null) continue;
            results[i++] = arg;
        }
        return Shorts.ensureCapacity(results, i);
    }

    public static short[] ensureCapacity(short[] array, int index) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        int length = array.length;
        if (index != length) {
            return Shorts.copy(array, 0, Math.min(index, length));
        }
        return array;
    }

    public static short[] expandCapacity(short[] array, int index) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        return Shorts.expandCapacity(array, index, array.length);
    }

    public static short[] expandCapacity(short[] array, int index, int size) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        int length = array.length;
        return Shorts.copy(array, 0, Math.max(length + size, length));
    }

    public static short max(short[] array) {
        Assert.isTrue(Shorts.isEmpty(array), "Empty array.", new Object[0]);
        short max = array[0];
        for (int i = 1; i < array.length; ++i) {
            max = max >= array[i] ? max : array[i];
        }
        return max;
    }

    public static short min(short[] array) {
        Assert.isTrue(Shorts.isEmpty(array), "Empty array.", new Object[0]);
        short min = array[0];
        for (int i = 1; i < array.length; ++i) {
            min = min <= array[i] ? min : array[i];
        }
        return min;
    }

    public static short sum(short[] array) {
        Assert.isTrue(Shorts.isEmpty(array), "Empty array.", new Object[0]);
        short sum = array[0];
        for (int i = 1; i < array.length; ++i) {
            sum = (short)(sum + array[i]);
        }
        return sum;
    }

    public static double avg(short[] array) {
        double sum = Shorts.sum(array);
        return sum / (double)array.length;
    }

    public static String toString(short[] array) {
        return "[" + Shorts.join(array) + "]";
    }

    public static String join(short[] array) {
        return Shorts.join(array, ",");
    }

    public static String join(short[] array, String delimiter) {
        if (Shorts.isEmpty(array)) {
            return "";
        }
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuilder str = new StringBuilder();
        int l = array.length;
        for (int i = 0; i < l; ++i) {
            str.append(array[i]);
            if (i == l - 1) continue;
            str.append(delimiter);
        }
        return str.toString();
    }

    public static String join(short[] left, short[] right, String delimiter) {
        return Shorts.join(left, right, delimiter, delimiter);
    }

    public static String join(short[] left, short[] right, String conjunction, String delimiter) {
        if (Shorts.isEmpty(left) || Shorts.isEmpty(right)) {
            return "";
        }
        if (conjunction == null) {
            conjunction = "";
        }
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuilder content = new StringBuilder();
        int l = Math.min(left.length, right.length);
        for (int i = 0; i < l; ++i) {
            content.append(left[i]).append(conjunction).append(right[i]);
            if (i == l - 1) continue;
            content.append(delimiter);
        }
        return content.toString();
    }

    public static void swap(short[] x, int a, int b) {
        short t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void sort(short[] array, int low, int high, boolean asc) {
        for (int i = low; i < high; ++i) {
            for (int j = i; j > low; --j) {
                if (!(asc ? array[j - 1] > array[j] : array[j - 1] < array[j])) continue;
                Shorts.swap(array, j - 1, j);
            }
        }
    }

    public static void sort(short[] array, boolean asc) {
        if (Shorts.isNotEmpty(array)) {
            short[] aux = (short[])array.clone();
            Shorts.mergeSort(aux, array, 0, array.length, asc);
        }
    }

    private static void mergeSort(short[] src, short[] dest, int low, int high, boolean asc) {
        int length = high - low;
        if (length < 10) {
            Shorts.sort(dest, low, high, asc);
            return;
        }
        int mid = (high + low) / 2;
        Shorts.mergeSort(dest, src, low, mid, asc);
        Shorts.mergeSort(dest, src, mid, high, asc);
        int i = low;
        int p = low;
        int q = mid;
        while (p < mid && q < high) {
            if (asc ? src[p] <= src[q] : src[p] > src[q]) {
                dest[i++] = src[p++];
                continue;
            }
            dest[i++] = src[q++];
        }
        while (p < mid && i < high) {
            dest[i++] = src[p++];
        }
        while (q < high && i < high) {
            dest[i++] = src[q++];
        }
    }

    public static short[] unionAll(short[] left, short[] right) {
        if (left == null && right == null) {
            return null;
        }
        if (left != null && right == null) {
            return left;
        }
        if (left == null && right != null) {
            return right;
        }
        short[] total = new short[left.length + right.length];
        int i = 0;
        for (short s : left) {
            total[i++] = s;
        }
        for (short s : right) {
            total[i++] = s;
        }
        return Shorts.ensureCapacity(total, i);
    }

    public static short[] union(short[] left, short[] right) {
        if (left == null && right == null) {
            return null;
        }
        if (left != null && right == null) {
            return left;
        }
        if (left == null && right != null) {
            return right;
        }
        short[] total = new short[left.length + right.length];
        int i = 0;
        for (short s : left) {
            if (Shorts.contains(total, s)) continue;
            total[i++] = s;
        }
        for (short s : right) {
            if (Shorts.contains(total, s)) continue;
            total[i++] = s;
        }
        return Shorts.ensureCapacity(total, i);
    }

    public static short[] minus(short[] left, short[] right) {
        int i;
        if (left == null && right == null) {
            return null;
        }
        if (left != null && right == null) {
            return left;
        }
        if (left == null && right != null) {
            return right;
        }
        short[] result = new short[right.length];
        for (i = 0; i < left.length; ++i) {
            if (Shorts.contains(right, left[i])) continue;
            result[i++] = left[i];
        }
        return Shorts.ensureCapacity(result, i);
    }

    public static short[] intersect(short[] left, short[] right) {
        int i;
        if (left == null && right == null) {
            return null;
        }
        if (left != null && right == null) {
            return left;
        }
        if (left == null && right != null) {
            return right;
        }
        short[] result = new short[right.length];
        for (i = 0; i < left.length; ++i) {
            if (!Shorts.contains(right, left[i])) continue;
            result[i++] = left[i];
        }
        return Shorts.ensureCapacity(result, i);
    }

    public static short[] toArray(Collection<?> collection) {
        Assert.isNull(collection, "Source collection must not be null.", new Object[0]);
        short[] array = new short[collection.size()];
        int i = 0;
        for (Object a : collection) {
            try {
                array[i++] = ((Number)a).shortValue();
            }
            catch (RuntimeException runtimeException) {}
        }
        return Shorts.ensureCapacity(array, i);
    }

    public static List<Short> toList(short[] array) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        ArrayList<Short> set = new ArrayList<Short>(array.length);
        for (short a : array) {
            set.add(a);
        }
        return set;
    }

    public static void reverse(short[] src) {
        int l = src.length;
        for (int i = 0; i < l / 2; ++i) {
            short a;
            short t = src[i];
            int j = l - 1 - i;
            src[i] = a = src[j];
            src[j] = t;
        }
    }

    public static int hashCode(short arg) {
        return arg;
    }

    public static boolean deepEquals(short[] left, short[] right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return right == null;
        }
        if (right == null) {
            return false;
        }
        int length = left.length;
        if (length != right.length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (left[i] == right[i]) continue;
            return false;
        }
        return true;
    }

    public static Short valueOf(Boolean b) {
        return Shorts.valueOf(b, null);
    }

    public static Short valueOf(Boolean b, Short defaultValue) {
        if (b == null) {
            return defaultValue;
        }
        return Shorts.cast(b);
    }

    public static Short valueOf(Character ch) {
        return Shorts.valueOf(ch, null);
    }

    public static Short valueOf(Character c, Short defaultValue) {
        if (c == null) {
            return defaultValue;
        }
        return Shorts.cast(c.charValue());
    }

    public static Short valueOf(String str) {
        return Shorts.valueOf(str, null);
    }

    public static Short valueOf(String str, Short defaultValue) {
        if (StringUtils.isBlank(str)) {
            return defaultValue;
        }
        try {
            return Shorts.parse(str);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public static Short[] valueOf(String[] strings) {
        return Shorts.valueOf(strings, null);
    }

    public static Short[] valueOf(String[] strings, Short defaultValue) {
        Assert.isNull(strings, "Source array must not be null.", new Object[0]);
        Short[] result = new Short[strings.length];
        int i = 0;
        for (String str : strings) {
            result[i++] = Shorts.valueOf(str, defaultValue);
        }
        return result;
    }

    public static short parse(String str) {
        Assert.hasNoText(str, "Number string must not be null.", new Object[0]);
        try {
            return Short.parseShort(str);
        }
        catch (NumberFormatException numberFormatException) {
            if (NumberUtils.isHex(str)) {
                try {
                    return Short.decode(str);
                }
                catch (NumberFormatException numberFormatException2) {
                    // empty catch block
                }
            }
            return Shorts.parseStrictly(str);
        }
    }

    private static short parseStrictly(String str) {
        Short pooled = cache.get(str);
        if (pooled == null) {
            String newStr = NumberUtils.read(str);
            if (!NumberUtils.isNumber(newStr)) {
                throw new NumberFormatException("Can not parse string for: " + str);
            }
            try {
                cache.put(str, Short.parseShort(newStr));
            }
            catch (NumberFormatException e) {
                cache.put(str, (short)Double.parseDouble(newStr));
            }
            pooled = cache.get(str);
        }
        return pooled;
    }

    public static short[] parseMany(String[] strings) {
        return Shorts.parseMany(strings, true);
    }

    public static short[] parseMany(String[] strings, boolean thrown) {
        Assert.isNull(strings, "Source array must not be null.", new Object[0]);
        short[] result = new short[strings.length];
        int i = 0;
        for (String str : strings) {
            try {
                short s = Shorts.parse(str);
                result[i++] = s;
            }
            catch (IllegalArgumentException e) {
                if (!thrown) continue;
                throw e;
            }
        }
        return Shorts.ensureCapacity(result, i);
    }

    public static short cast(boolean b) {
        return (short)(b ? 1 : 0);
    }

    public static short[] casts(boolean[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        short[] result = new short[value.length];
        int i = 0;
        for (boolean val : value) {
            result[i++] = Shorts.cast(val);
        }
        return result;
    }

    public static short cast(char value) {
        short s = (short)value;
        if (s != value) {
            throw new NumberOverflowException("short");
        }
        return s;
    }

    public static short[] casts(char[] value) {
        return Shorts.casts(value, true);
    }

    public static short[] casts(char[] value, boolean thrown) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        short[] result = new short[value.length];
        int i = 0;
        for (char val : value) {
            try {
                result[i++] = Shorts.cast(val);
            }
            catch (IllegalArgumentException e) {
                if (!thrown) continue;
                throw e;
            }
        }
        return result;
    }

    public static short[] casts(byte[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        short[] result = new short[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = value[i];
        }
        return result;
    }

    public static short[] casts(int[] value) {
        return Shorts.casts(value, true);
    }

    public static short[] casts(int[] value, boolean thrown) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        short[] result = new short[value.length];
        int i = 0;
        for (int val : value) {
            try {
                result[i++] = Shorts.cast(val);
            }
            catch (IllegalArgumentException e) {
                if (!thrown) continue;
                throw e;
            }
        }
        return result;
    }

    public static short cast(Number value) {
        if (value instanceof BigDecimal) {
            return Shorts.cast((BigDecimal)value);
        }
        if (value instanceof BigInteger) {
            return Shorts.cast((BigInteger)value);
        }
        return Shorts.cast(value.longValue());
    }

    public static short cast(long value) {
        short converted = (short)value;
        if (value != (long)converted) {
            throw new NumberOverflowException("short");
        }
        return converted;
    }

    public static short cast(BigDecimal value) {
        return Shorts.cast(value.toBigInteger());
    }

    public static short cast(BigInteger value) {
        if (NumberRange.checkShort(value)) {
            throw new NumberOverflowException("short");
        }
        return value.shortValue();
    }

    public static short[] casts(long[] value) {
        return Shorts.casts(value, true);
    }

    public static short[] casts(long[] value, boolean thrown) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        short[] result = new short[value.length];
        int i = 0;
        for (long val : value) {
            try {
                result[i++] = Shorts.cast(val);
            }
            catch (IllegalArgumentException e) {
                if (!thrown) continue;
                throw e;
            }
        }
        return result;
    }

    public static short cast(float value) {
        return Shorts.cast((Number)value);
    }

    public static short[] casts(float[] value) {
        return Shorts.casts(value, true);
    }

    public static short[] casts(float[] value, boolean thrown) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        short[] result = new short[value.length];
        int i = 0;
        for (float val : value) {
            try {
                result[i++] = Shorts.cast(val);
            }
            catch (IllegalArgumentException e) {
                if (!thrown) continue;
                throw e;
            }
        }
        return result;
    }

    public static short[] casts(double[] value) {
        return Shorts.casts(value, true);
    }

    public static short[] casts(double[] value, boolean thrown) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        short[] result = new short[value.length];
        int i = 0;
        for (double val : value) {
            try {
                result[i++] = Shorts.cast(val);
            }
            catch (IllegalArgumentException e) {
                if (!thrown) continue;
                throw e;
            }
        }
        return result;
    }

    public static short[] casts(Number[] array) {
        return Shorts.casts(array, true);
    }

    public static short[] casts(Number[] array, boolean thrown) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        short[] result = new short[array.length];
        int i = 0;
        for (Number n : array) {
            try {
                result[i++] = Shorts.cast(n);
            }
            catch (IllegalArgumentException e) {
                if (!thrown) continue;
                throw e;
            }
        }
        return Shorts.ensureCapacity(result, i);
    }

    public static Short valueOf(Number n) {
        return Shorts.valueOf(n, null);
    }

    public static Short valueOf(Number n, Short defaultValue) {
        if (n == null) {
            return defaultValue;
        }
        if (n instanceof Short) {
            return (Short)n;
        }
        try {
            return Shorts.cast(n);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public static Short[] valueOf(Number[] array) {
        return Shorts.valueOf(array, null);
    }

    public static Short[] valueOf(Number[] array, Short defaultValue) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        Short[] result = new Short[array.length];
        int i = 0;
        for (Number arg : array) {
            result[i++] = Shorts.valueOf(arg, defaultValue);
        }
        return result;
    }

    public static int deepHashCode(short[] args) {
        Assert.isNull(args, "Source array must not be null.", new Object[0]);
        int hash = 0;
        for (int i = 0; i < args.length; ++i) {
            hash += Shorts.hashCode(args[i]);
        }
        return hash;
    }

    public static String[] toStringArray(short[] args, DecimalFormat df) {
        int l = args.length;
        String[] array = new String[l];
        for (int i = 0; i < l; ++i) {
            array[i] = df != null ? df.format(args[i]) : String.valueOf(args[i]);
        }
        return array;
    }

    public static boolean isEven(short value) {
        return (value & 1) == 0;
    }

    public static boolean isEvens(short[] values) {
        for (short s : values) {
            if (!Shorts.isOdd(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean isOdds(short[] values) {
        for (short s : values) {
            if (!Shorts.isEven(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean isOdd(short value) {
        return !Shorts.isEven(value);
    }

    public static boolean isSameLength(short[] left, short[] right) {
        if (left == null) {
            return right != null ? right.length == 0 : true;
        }
        if (right == null) {
            return left != null ? left.length == 0 : true;
        }
        return left.length == right.length;
    }

    public static boolean same(short[] array) {
        return Shorts.isSerial(array, 0);
    }

    public static boolean isSerial(short[] array) {
        return Shorts.isSerial(array, 1);
    }

    public static boolean isSerial(short[] array, int n) {
        if (Shorts.isEmpty(array)) {
            return false;
        }
        for (int i = array.length - 1; i > 0; --i) {
            if (array[i] - array[i - 1] == n) continue;
            return false;
        }
        return true;
    }

    public static boolean isSubarray(short[] left, short[] right) {
        if (Shorts.isEmpty(left) || Shorts.isEmpty(right) || left.length < right.length) {
            return false;
        }
        for (int i = 0; i < left.length; ++i) {
            if (left[i] != right[0]) continue;
            boolean f = true;
            for (int j = 1; j < right.length; ++j) {
                if (i + j == left.length) {
                    return false;
                }
                if (left[i + j] == right[j]) continue;
                f = false;
                break;
            }
            if (!f) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(short[] left, short[] right) {
        if (Shorts.isEmpty(left) || Shorts.isEmpty(right) || left.length < right.length) {
            return false;
        }
        for (short s : right) {
            if (!Shorts.notContains(left, s)) continue;
            return false;
        }
        return true;
    }

    public static void leftScroll(short[] src, int n) {
        if (Shorts.isNotEmpty(src) && n > 0) {
            int l = src.length;
            Shorts.rightScroll(src, l - n);
        }
    }

    public static void rightScroll(short[] src, int n) {
        if (Shorts.isNotEmpty(src) && n > 0) {
            int l = src.length;
            Shorts.rightScroll(src, 0, l - (n %= l) - 1);
            Shorts.rightScroll(src, l - n, l - 1);
            Shorts.rightScroll(src, 0, l - 1);
        }
    }

    private static void rightScroll(short[] src, int n, int m) {
        while (n < m) {
            Shorts.swap(src, m, n);
            ++n;
            --m;
        }
    }

    public static void shuffle(short[] src) {
        Shorts.shuffle(src, ThreadLocalRandom.current());
    }

    public static void shuffle(short[] src, Random rn) {
        for (int i = src.length; i > 1; --i) {
            Shorts.swap(src, i - 1, rn.nextInt(i));
        }
    }

    public static Comparator<short[]> defaultComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static int compare(short a, short b) {
        return a - b;
    }

    private static enum LexicographicalComparator implements Comparator<short[]>
    {
        INSTANCE;


        @Override
        public int compare(short[] left, short[] right) {
            int minLength = Math.min(left.length, right.length);
            for (int i = 0; i < minLength; ++i) {
                int result = Shorts.compare(left[i], right[i]);
                if (result == 0) continue;
                return result;
            }
            return left.length - right.length;
        }
    }
}

