/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.regex;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.regex.RegexUtils;
import java.util.Enumeration;

public class RegexTokenizer
implements Enumeration<String> {
    private final String value;
    private final String[] regexes;
    private final int maxPosition;
    private final boolean returnDelims;
    private int startPosition = 0;
    private int endPosition = -1;
    private int offset;
    private String last;
    private String delim;
    private boolean empty;
    private boolean even;
    private int flags = 0;

    public RegexTokenizer(CharSequence content, String regex, boolean returnDelim) {
        this(content, new String[]{regex}, returnDelim);
    }

    public RegexTokenizer(CharSequence content, String[] regexes, boolean returnDelim) {
        Assert.hasNoText(content, "Content must not be null or empty.", new Object[0]);
        this.value = content.toString();
        this.maxPosition = content.length();
        this.regexes = regexes;
        this.returnDelims = returnDelim;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    private int locate(int fromIndex) {
        int j = -1;
        for (String regex : this.regexes) {
            String m = RegexUtils.match(this.value, regex, this.flags, fromIndex);
            if (!StringUtils.isNotBlank(m)) continue;
            int i = this.value.indexOf(m, fromIndex);
            if (j != -1 && i >= j) continue;
            this.delim = m;
            j = i;
        }
        int n = this.offset = this.delim != null ? this.delim.length() : 0;
        if (j == -1) {
            j = this.maxPosition;
        }
        return j;
    }

    private boolean test() {
        this.endPosition = this.locate(this.startPosition);
        this.empty = this.startPosition == this.endPosition;
        this.even = this.empty && this.returnDelims;
        return this.empty;
    }

    @Override
    public boolean hasMoreElements() {
        if (this.startPosition >= this.maxPosition) {
            if (this.returnDelims) {
                return this.even && this.offset > 0;
            }
            return false;
        }
        if (this.returnDelims && this.even) {
            return true;
        }
        while (this.test() && !this.even) {
            this.startPosition = this.endPosition + this.offset;
        }
        return this.startPosition < this.maxPosition;
    }

    @Override
    public String nextElement() {
        if (this.returnDelims && this.even) {
            this.last = this.delim;
            this.delim = null;
            this.even = false;
            if (this.empty) {
                this.startPosition = this.endPosition + this.offset;
            }
        } else {
            this.last = this.value.substring(this.startPosition, this.endPosition);
            this.startPosition = this.endPosition + this.offset;
            this.even = true;
        }
        return this.last;
    }

    public String getLastElement() {
        return this.last;
    }
}

