/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools;

import com.github.paganini2008.devtools.ArrayUtils;
import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.ObjectUtils;
import com.github.paganini2008.devtools.collection.MapUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;

public abstract class ClassUtils {
    public static final Class<?>[] EMPTY_ARRAY = new Class[0];
    private static final Map<Class<?>, Class<?>> primitiveWrapperMapper = new LinkedHashMap();
    private static final Map<Class<?>, Class<?>> wrapperPrimitiveMapper;
    private static final Map<String, Object> primitiveDefaultValueMap;
    private static final Map<String, Object> wrapperDefaultValueMap;
    private static final Map<String, String> abbreviationMap;
    private static final Map<String, String> reverseAbbreviationMap;
    private static final Map<String, Class<?>> primitiveArrayClassMap;
    private static final Map<String, Class<?>> wrapperArrayClassMap;

    public static Class<?> getPrimitiveArrayClass(String name) {
        return primitiveArrayClassMap.get(name);
    }

    public static Class<?> getWrapperArrayClass(String name) {
        return wrapperArrayClassMap.get(name);
    }

    public static boolean isPrimitiveOrWrapper(Class<?> type) {
        return type != null && (type.isPrimitive() || wrapperPrimitiveMapper.containsKey(type));
    }

    public static String getAbbreviation(String name) {
        if (name == null) {
            return "";
        }
        return abbreviationMap.get(name.toLowerCase());
    }

    public static String getName(String name) {
        if (name == null) {
            return "";
        }
        return reverseAbbreviationMap.get(name.toUpperCase());
    }

    public static Class<?> toWrapper(Class<?> type) {
        if (type != null && type.isPrimitive()) {
            return primitiveWrapperMapper.get(type);
        }
        return type;
    }

    public static Class<?> toPrimitive(Class<?> type) {
        if (type != null && wrapperPrimitiveMapper.containsKey(type)) {
            return wrapperPrimitiveMapper.get(type);
        }
        return type;
    }

    public static boolean isArray(Class<?> c) {
        return c != null ? c.isArray() : false;
    }

    public static boolean isNotArray(Class<?> c) {
        return !ClassUtils.isArray(c);
    }

    public static boolean isNotBoolean(Class<?> clazz) {
        return !ClassUtils.isBoolean(clazz);
    }

    public static boolean isBoolean(Class<?> clazz) {
        return clazz != null ? Boolean.class == clazz || Boolean.TYPE == clazz : false;
    }

    public static boolean isNotCharacter(Class<?> clazz) {
        return !ClassUtils.isCharacter(clazz);
    }

    public static boolean isCharacter(Class<?> clazz) {
        return clazz != null ? Character.class == clazz || Character.TYPE == clazz : false;
    }

    public static boolean isNotByte(Class<?> clazz) {
        return !ClassUtils.isByte(clazz);
    }

    public static boolean isByte(Class<?> clazz) {
        return clazz != null ? Byte.class == clazz || Byte.TYPE == clazz : false;
    }

    public static boolean isNotShort(Class<?> clazz) {
        return !ClassUtils.isShort(clazz);
    }

    public static boolean isShort(Class<?> clazz) {
        return clazz != null ? Short.class == clazz || Short.TYPE == clazz : false;
    }

    public static boolean isNotInteger(Class<?> clazz) {
        return !ClassUtils.isInteger(clazz);
    }

    public static boolean isInteger(Class<?> clazz) {
        return clazz != null ? Integer.class == clazz || Integer.TYPE == clazz : false;
    }

    public static boolean isNotFloat(Class<?> clazz) {
        return !ClassUtils.isFloat(clazz);
    }

    public static boolean isFloat(Class<?> clazz) {
        return clazz != null ? Float.class == clazz || Float.TYPE == clazz : false;
    }

    public static boolean isNotDouble(Class<?> clazz) {
        return !ClassUtils.isDouble(clazz);
    }

    public static boolean isDouble(Class<?> clazz) {
        return clazz != null ? Double.class == clazz || Double.TYPE == clazz : false;
    }

    public static boolean isNotLong(Class<?> clazz) {
        return !ClassUtils.isLong(clazz);
    }

    public static boolean isLong(Class<?> clazz) {
        return clazz != null ? Long.class == clazz || Long.TYPE == clazz : false;
    }

    public static boolean isNotAssignableFrom(Class<?> superClass, Class<?> clazz) {
        return !ClassUtils.isAssignableFrom(superClass, clazz);
    }

    public static boolean isAssignableFrom(Class<?> superClass, Class<?> clazz) {
        return superClass != null && clazz != null && superClass.isAssignableFrom(clazz);
    }

    public static Class<?> getType(Class<?> type) {
        return type != null ? (type.isArray() ? type.getComponentType() : type) : null;
    }

    public static List<ParameterizedType> getAllParameterizedTypes(Class<?> objectClass) {
        Assert.isNull(objectClass, " Class object can not be null.", new Object[0]);
        ArrayList<ParameterizedType> parameterizedTypesFound = new ArrayList<ParameterizedType>();
        ClassUtils.getAllParameterizedTypes(objectClass, parameterizedTypesFound);
        return parameterizedTypesFound;
    }

    private static void getAllParameterizedTypes(Class<?> objectClass, List<ParameterizedType> parameterizedTypesFound) {
        while (objectClass != null) {
            Type[] types = objectClass.getGenericInterfaces();
            for (int i = 0; i < types.length; ++i) {
                if (types[i] instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType)types[i];
                    if (parameterizedTypesFound.contains(parameterizedType)) continue;
                    parameterizedTypesFound.add(parameterizedType);
                    ClassUtils.getAllParameterizedTypes((Class)parameterizedType.getRawType(), parameterizedTypesFound);
                    continue;
                }
                ClassUtils.getAllParameterizedTypes((Class)types[i], parameterizedTypesFound);
            }
            objectClass = objectClass.getSuperclass();
        }
    }

    public static List<Class<?>> getAllInterfaces(Class<?> cls) {
        Assert.isNull(cls, " Class object can not be null.", new Object[0]);
        ArrayList interfacesFound = new ArrayList();
        ClassUtils.getAllInterfaces(cls, interfacesFound);
        return interfacesFound;
    }

    private static void getAllInterfaces(Class<?> cls, List<Class<?>> interfacesFound) {
        while (cls != null) {
            Class<?>[] interfaces = cls.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (interfacesFound.contains(interfaces[i])) continue;
                interfacesFound.add(interfaces[i]);
                ClassUtils.getAllInterfaces(interfaces[i], interfacesFound);
            }
            cls = cls.getSuperclass();
        }
    }

    public static List<Class<?>> getAllSuperClasses(Class<?> cls) {
        Assert.isNull(cls, " Class object can not be null.", new Object[0]);
        ArrayList superClassesFound = new ArrayList();
        ClassUtils.getAllSuperClasses(cls.getSuperclass(), superClassesFound);
        return superClassesFound;
    }

    private static void getAllSuperClasses(Class<?> cls, List<Class<?>> superClassesFound) {
        while (cls != null && cls != Object.class) {
            if (!superClassesFound.contains(cls)) {
                superClassesFound.add(cls);
            }
            cls = cls.getSuperclass();
        }
    }

    public static List<Class<?>> getAllSuperClassesAndInterfaces(Class<?> cls) {
        Assert.isNull(cls, " Class object can not be null.", new Object[0]);
        ArrayList found = new ArrayList();
        ClassUtils.getAllSuperClassesAndInterfaces(cls, found);
        return found;
    }

    private static void getAllSuperClassesAndInterfaces(Class<?> cls, List<Class<?>> found) {
        if (cls != null && cls != Object.class) {
            Class<?>[] interfaces;
            Class<?> superClass = cls.getSuperclass();
            if (superClass != Object.class && !found.contains(superClass)) {
                found.add(superClass);
            }
            for (Class<?> interfaceClass : interfaces = cls.getInterfaces()) {
                if (found.contains(interfaceClass)) continue;
                found.add(interfaceClass);
                ClassUtils.getAllInterfaces(interfaceClass, found);
            }
            ClassUtils.getAllSuperClassesAndInterfaces(superClass, found);
        }
    }

    public static boolean isAssignable(Class<?>[] types, Class<?> actual) {
        int length = types != null ? types.length : 0;
        for (int i = 0; i < length; ++i) {
            if (!ClassUtils.isAssignable(types[i], actual)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotAssignable(Class<?>[] types, Class<?>[] toTypes) {
        return !ClassUtils.isAssignable(types, toTypes);
    }

    public static boolean isAssignable(Class<?>[] types, Class<?>[] toTypes) {
        if (ArrayUtils.isNotSameLength(types, toTypes)) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            if (!ClassUtils.isNotAssignable(types[i], toTypes[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Class<?>[] types, Class<?>[] toTypes) {
        if (ArrayUtils.isNotSameLength(types, toTypes)) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            if (!ObjectUtils.notEquals(types[i], toTypes[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotAssignable(Class<?> original, Class<?> actual) {
        return !ClassUtils.isAssignable(original, actual);
    }

    public static boolean isAssignable(Class<?> original, Class<?> actual) {
        if (original == null || actual == null) {
            return false;
        }
        if (actual.isPrimitive() && !original.isPrimitive()) {
            actual = ClassUtils.toWrapper(actual);
        } else if (!actual.isPrimitive() && original.isPrimitive()) {
            actual = ClassUtils.toPrimitive(actual);
        }
        return original.equals(actual) || original.isAssignableFrom(actual);
    }

    public static Class<?> forName(String className) {
        Assert.hasNoText(className);
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static void main(String[] args) {
        System.out.println(ClassUtils.getAllSuperClassesAndInterfaces(ThreadPoolExecutor.class));
    }

    static {
        primitiveWrapperMapper.put(Byte.TYPE, Byte.class);
        primitiveWrapperMapper.put(Short.TYPE, Short.class);
        primitiveWrapperMapper.put(Integer.TYPE, Integer.class);
        primitiveWrapperMapper.put(Long.TYPE, Long.class);
        primitiveWrapperMapper.put(Float.TYPE, Float.class);
        primitiveWrapperMapper.put(Double.TYPE, Double.class);
        primitiveWrapperMapper.put(Boolean.TYPE, Boolean.class);
        primitiveWrapperMapper.put(Character.TYPE, Character.class);
        wrapperPrimitiveMapper = MapUtils.invert(primitiveWrapperMapper);
        primitiveDefaultValueMap = new LinkedHashMap<String, Object>();
        primitiveDefaultValueMap.put("byte", 0);
        primitiveDefaultValueMap.put("short", 0);
        primitiveDefaultValueMap.put("int", 0);
        primitiveDefaultValueMap.put("long", 0L);
        primitiveDefaultValueMap.put("float", Float.valueOf(0.0f));
        primitiveDefaultValueMap.put("double", 0.0);
        primitiveDefaultValueMap.put("boolean", false);
        primitiveDefaultValueMap.put("char", Character.valueOf('\u0000'));
        wrapperDefaultValueMap = new LinkedHashMap<String, Object>();
        wrapperDefaultValueMap.put("Byte", 0);
        wrapperDefaultValueMap.put("Short", 0);
        wrapperDefaultValueMap.put("Integer", 0);
        wrapperDefaultValueMap.put("Long", 0L);
        wrapperDefaultValueMap.put("Float", Float.valueOf(0.0f));
        wrapperDefaultValueMap.put("Double", 0.0);
        wrapperDefaultValueMap.put("Boolean", Boolean.FALSE);
        wrapperDefaultValueMap.put("Character", Character.valueOf('\u0000'));
        abbreviationMap = new LinkedHashMap<String, String>();
        abbreviationMap.put("int", "I");
        abbreviationMap.put("boolean", "Z");
        abbreviationMap.put("float", "F");
        abbreviationMap.put("long", "J");
        abbreviationMap.put("short", "S");
        abbreviationMap.put("byte", "B");
        abbreviationMap.put("double", "D");
        abbreviationMap.put("char", "C");
        reverseAbbreviationMap = MapUtils.invert(abbreviationMap);
        primitiveArrayClassMap = new LinkedHashMap();
        primitiveArrayClassMap.put("byte[]", byte[].class);
        primitiveArrayClassMap.put("short[]", short[].class);
        primitiveArrayClassMap.put("int[]", int[].class);
        primitiveArrayClassMap.put("long[]", long[].class);
        primitiveArrayClassMap.put("float[]", float[].class);
        primitiveArrayClassMap.put("double[]", double[].class);
        primitiveArrayClassMap.put("boolean[]", boolean[].class);
        primitiveArrayClassMap.put("char[]", char[].class);
        wrapperArrayClassMap = new LinkedHashMap();
        wrapperArrayClassMap.put("Byte[]", Byte[].class);
        wrapperArrayClassMap.put("Short[]", Short[].class);
        wrapperArrayClassMap.put("Integer[]", Integer[].class);
        wrapperArrayClassMap.put("Long[]", Long[].class);
        wrapperArrayClassMap.put("Float[]", Float[].class);
        wrapperArrayClassMap.put("Double[]", Double[].class);
        wrapperArrayClassMap.put("Boolean[]", Boolean[].class);
        wrapperArrayClassMap.put("Character[]", Character[].class);
    }
}

