/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools;

import com.github.paganini2008.devtools.primitives.Doubles;
import com.github.paganini2008.devtools.primitives.Floats;
import com.github.paganini2008.devtools.primitives.Ints;
import com.github.paganini2008.devtools.primitives.Longs;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public abstract class RandomUtils {
    public static byte randomChoice(byte[] choice) {
        return choice[RandomUtils.randomInt(0, choice.length)];
    }

    public static byte randomChoice(byte[] choice, int length) {
        return choice[RandomUtils.randomInt(0, Math.min(length, choice.length))];
    }

    public static short randomChoice(short[] choice) {
        return choice[RandomUtils.randomInt(0, choice.length)];
    }

    public static short randomChoice(short[] choice, int length) {
        return choice[RandomUtils.randomInt(0, Math.min(length, choice.length))];
    }

    public static int randomChoice(int[] choice) {
        return choice[RandomUtils.randomInt(0, choice.length)];
    }

    public static int randomChoice(int[] choice, int length) {
        return choice[RandomUtils.randomInt(0, Math.min(length, choice.length))];
    }

    public static long randomChoice(long[] choice) {
        return choice[RandomUtils.randomInt(0, choice.length)];
    }

    public static long randomChoice(long[] choice, int length) {
        return choice[RandomUtils.randomInt(0, Math.min(length, choice.length))];
    }

    public static float randomChoice(float[] choice) {
        return choice[RandomUtils.randomInt(0, choice.length)];
    }

    public static float randomChoice(float[] choice, int length) {
        return choice[RandomUtils.randomInt(0, Math.min(length, choice.length))];
    }

    public static double randomChoice(double[] choice) {
        return choice[RandomUtils.randomInt(0, choice.length)];
    }

    public static double randomChoice(double[] choice, int length) {
        return choice[RandomUtils.randomInt(0, Math.min(length, choice.length))];
    }

    public static char randomChoice(char[] choice) {
        return choice[RandomUtils.randomInt(0, choice.length)];
    }

    public static char randomChoice(char[] choice, int length) {
        return choice[RandomUtils.randomInt(0, Math.min(length, choice.length))];
    }

    public static boolean randomChoice(boolean[] choice) {
        return choice[RandomUtils.randomInt(0, choice.length)];
    }

    public static boolean randomChoice(boolean[] choice, int length) {
        return choice[RandomUtils.randomInt(0, Math.min(length, choice.length))];
    }

    public static <T> T randomChoice(T[] choice) {
        return choice[RandomUtils.randomInt(0, choice.length)];
    }

    public static <T> T randomChoice(T[] choice, int length) {
        return choice[RandomUtils.randomInt(0, Math.min(length, choice.length))];
    }

    public static <T> T randomChoice(List<T> list) {
        return list.get(RandomUtils.randomInt(0, list.size()));
    }

    public static <T> T randomChoice(List<T> list, int length) {
        return list.get(RandomUtils.randomInt(0, Math.min(length, list.size())));
    }

    public static long randomLong(long from, long to) {
        return (long)Math.floor(RandomUtils.randomDouble(from, to));
    }

    public static long[] randomLongs(int length, long from, long to) {
        long[] results = new long[length];
        for (int i = 0; i < length; ++i) {
            long a;
            while (Longs.contains(results, a = RandomUtils.randomLong(from, to))) {
            }
            results[i] = a;
        }
        return results;
    }

    private static double nextDouble() {
        return ThreadLocalRandom.current().nextDouble();
    }

    public static float randomFloat(long from, long to) {
        return (float)RandomUtils.randomDouble(from, to);
    }

    public static float randomFloat(long from, long to, int scale) {
        float f = RandomUtils.randomFloat(from, to);
        return Floats.toFixed(f, 2);
    }

    public static float[] randomFloats(int length, long from, long to) {
        float[] results = new float[length];
        for (int i = 0; i < length; ++i) {
            float a;
            while (Floats.contains(results, a = RandomUtils.randomFloat(from, to))) {
            }
            results[i] = a;
        }
        return results;
    }

    public static int randomInt(int from, int to) {
        return (int)RandomUtils.randomLong(from, to);
    }

    public static int[] randomInts(int length, int from, int to) {
        int[] results = new int[length];
        for (int i = 0; i < length; ++i) {
            int a;
            while (Ints.contains(results, a = RandomUtils.randomInt(from, to))) {
            }
            results[i] = a;
        }
        return results;
    }

    public static double randomDouble(long from, long to) {
        return RandomUtils.nextDouble() * (double)(to - from) + (double)from;
    }

    public static double[] randomDoubles(int length, long from, long to) {
        double[] results = new double[length];
        for (int i = 0; i < length; ++i) {
            double d;
            while (Doubles.contains(results, d = RandomUtils.randomDouble(from, to))) {
            }
            results[i] = d;
        }
        return results;
    }

    public static boolean randomBoolean() {
        return RandomUtils.randomInt(0, 2) == 1;
    }

    public static void main(String[] args) throws Exception {
    }
}

